-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1
-- Tiempo de generación: 03-04-2025 a las 22:06:13
-- Versión del servidor: 10.4.32-MariaDB
-- Versión de PHP: 8.0.30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `votos`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `candidatos`
--

CREATE TABLE `candidatos` (
  `id` int(10) UNSIGNED NOT NULL,
  `id_eleccion` int(10) UNSIGNED NOT NULL COMMENT 'A qué elección pertenece este candidato.',
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) NOT NULL,
  `partido_politico` varchar(150) DEFAULT NULL COMMENT 'Nombre del partido o alianza (NULL si es independiente).',
  `foto_url` varchar(255) DEFAULT NULL COMMENT 'Ruta relativa o absoluta a la foto del candidato.',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Candidatos participantes en una elección';

--
-- Volcado de datos para la tabla `candidatos`
--

INSERT INTO `candidatos` (`id`, `id_eleccion`, `nombre`, `apellido`, `partido_politico`, `foto_url`, `created_at`, `updated_at`) VALUES
(1, 1, 'FELIPE NICOLAS', 'CARRASCO', 'PODEMOS', 'uploads/candidatos/candidato_67eecd4236ee52.25363338.png', '2025-04-03 18:02:42', '2025-04-03 18:36:16'),
(2, 1, 'DIVINO MAESTRO', 'garc', 'APPggg', 'uploads/candidatos/candidato_67eecd73ebe678.74959005.jpg', '2025-04-03 18:03:31', '2025-04-03 18:36:23'),
(3, 1, 'PEPITO', 'PALOTES', 'SUMATE', 'uploads/candidatos/candidato_67eed96e2af178.86072698.png', '2025-04-03 18:54:38', '2025-04-03 18:54:38'),
(4, 1, 'NUERÑA', 'CHOCO', 'AVANZA', 'uploads/candidatos/candidato_67eed981a14ec8.79782939.jpeg', '2025-04-03 18:54:57', '2025-04-03 18:54:57'),
(5, 1, 'ZAVALETE', 'RICHAR', 'MORADO', 'uploads/candidatos/candidato_67eed995a0aa35.56060564.png', '2025-04-03 18:55:17', '2025-04-03 18:55:17'),
(6, 1, 'JAIME', 'GAR', 'ZUAS', 'uploads/candidatos/candidato_67eed9a6173142.05029580.png', '2025-04-03 18:55:34', '2025-04-03 18:55:34');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `centros`
--

CREATE TABLE `centros` (
  `id` int(10) UNSIGNED NOT NULL,
  `localidad` varchar(191) NOT NULL COMMENT 'Descripción de la localidad (reducido para índice).',
  `nombre_ie` varchar(191) NOT NULL COMMENT 'Nombre de la Institución Educativa (reducido para índice).',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Catálogo de Centros de Votación (Instituciones)';

--
-- Volcado de datos para la tabla `centros`
--

INSERT INTO `centros` (`id`, `localidad`, `nombre_ie`, `created_at`, `updated_at`) VALUES
(1, 'CARTAVIO', 'DIVINO', '2025-04-03 18:03:54', '2025-04-03 18:03:54'),
(2, 'CARTAVIO', 'SAGRADO CORAZON', '2025-04-03 18:04:52', '2025-04-03 18:04:52'),
(3, 'CHIQUITOY', 'IRIS BARRIGA', '2025-04-03 18:56:29', '2025-04-03 18:56:29'),
(4, 'CHIQUITOY', 'CASA', '2025-04-03 18:56:45', '2025-04-03 18:56:45'),
(5, 'SANTIAGO DE CAO', 'MANUEL AREVALO', '2025-04-03 18:57:02', '2025-04-03 18:57:02'),
(6, 'SANTIAGO DE CAO', 'ESCUELA 2', '2025-04-03 18:57:16', '2025-04-03 18:57:16');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `centros_votacion`
--

CREATE TABLE `centros_votacion` (
  `id` int(10) UNSIGNED NOT NULL COMMENT 'ID único para cada registro de mesa en una elección.',
  `id_eleccion` int(10) UNSIGNED NOT NULL COMMENT 'A qué elección pertenece esta mesa.',
  `id_centro` int(10) UNSIGNED NOT NULL COMMENT 'A qué centro (Institución/Localidad) pertenece esta mesa.',
  `numero_mesa` varchar(20) NOT NULL COMMENT 'Número o identificador de la mesa dentro del centro.',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Mesas de votación por elección y centro';

--
-- Volcado de datos para la tabla `centros_votacion`
--

INSERT INTO `centros_votacion` (`id`, `id_eleccion`, `id_centro`, `numero_mesa`, `created_at`, `updated_at`) VALUES
(1, 1, 1, 'M009', '2025-04-03 18:03:54', '2025-04-03 18:39:24'),
(2, 1, 1, 'M008', '2025-04-03 18:04:09', '2025-04-03 20:03:47'),
(3, 1, 2, 'M003', '2025-04-03 18:04:52', '2025-04-03 18:04:52'),
(4, 1, 2, 'M004', '2025-04-03 18:05:01', '2025-04-03 18:05:01'),
(5, 1, 3, 'M010', '2025-04-03 18:56:29', '2025-04-03 18:56:29'),
(6, 1, 4, 'M011', '2025-04-03 18:56:45', '2025-04-03 18:56:45'),
(7, 1, 5, 'M020', '2025-04-03 18:57:02', '2025-04-03 18:57:02'),
(8, 1, 6, 'M030', '2025-04-03 18:57:16', '2025-04-03 18:57:16');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `elecciones`
--

CREATE TABLE `elecciones` (
  `id` int(10) UNSIGNED NOT NULL,
  `nombre` varchar(255) NOT NULL COMMENT 'Nombre descriptivo de la elección.',
  `fecha` date NOT NULL COMMENT 'Fecha principal del evento electoral.',
  `descripcion` text DEFAULT NULL COMMENT 'Descripción adicional o detalles.',
  `estado` enum('pendiente','en_curso','finalizada','cancelada') NOT NULL DEFAULT 'pendiente' COMMENT 'Estado actual de la elección.',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Tabla de eventos electorales';

--
-- Volcado de datos para la tabla `elecciones`
--

INSERT INTO `elecciones` (`id`, `nombre`, `fecha`, `descripcion`, `estado`, `created_at`, `updated_at`) VALUES
(1, 'Elecciones Municipales Ejemplo 2024', '2024-11-10', 'Elección simulada para probar el sistema.', 'pendiente', '2025-04-03 16:59:24', '2025-04-03 16:59:24');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(10) UNSIGNED NOT NULL,
  `nombre_usuario` varchar(50) NOT NULL COMMENT 'Nombre único para el login.',
  `password` varchar(255) NOT NULL COMMENT 'IMPORTANTE: Almacena el HASH de la contraseña, NUNCA texto plano.',
  `rol` enum('administrador','registrador') NOT NULL DEFAULT 'registrador' COMMENT 'Define los permisos del usuario.',
  `nombre_completo` varchar(150) DEFAULT NULL COMMENT 'Nombre real del usuario (opcional).',
  `activo` tinyint(1) NOT NULL DEFAULT 1 COMMENT '0 = Inactivo, 1 = Activo.',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Usuarios del sistema de administración';

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id`, `nombre_usuario`, `password`, `rol`, `nombre_completo`, `activo`, `created_at`, `updated_at`) VALUES
(1, 'kasparov', '$2y$10$zXi7HrQkbt2dv2ljI.cpEuZ1fUWk2rlOjmw4OdLlWSE24s.U6VYCW', 'administrador', 'Felipe Altamirano', 1, '2025-04-03 16:59:13', '2025-04-03 19:21:53'),
(2, 'registrador', '$2y$10$KY.bdwnqhBIqVp4xen6X2OmnofnKyNjgjtcBGYIc6Oddyv29TcSam', 'registrador', 'Usuario Registrador', 0, '2025-04-03 16:59:13', '2025-04-03 20:04:48');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `votos`
--

CREATE TABLE `votos` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `id_eleccion` int(10) UNSIGNED NOT NULL,
  `id_candidato` int(10) UNSIGNED NOT NULL,
  `id_centro_votacion` int(10) UNSIGNED NOT NULL COMMENT 'FK al ID de la tabla centros_votacion (la mesa específica).',
  `id_usuario_registro` int(10) UNSIGNED NOT NULL COMMENT 'Usuario que registró estos votos.',
  `cantidad_votos` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'Número de votos registrados en esta entrada.',
  `timestamp_registro` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Momento en que se ingresó el registro.',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Registro detallado de votos por candidato y mesa';

--
-- Volcado de datos para la tabla `votos`
--

INSERT INTO `votos` (`id`, `id_eleccion`, `id_candidato`, `id_centro_votacion`, `id_usuario_registro`, `cantidad_votos`, `timestamp_registro`, `updated_at`) VALUES
(1, 1, 2, 3, 1, 55, '2025-04-03 18:05:20', '2025-04-03 18:44:12'),
(2, 1, 1, 3, 1, 30, '2025-04-03 18:05:42', '2025-04-03 18:52:59'),
(3, 1, 2, 2, 1, 50, '2025-04-03 18:05:49', '2025-04-03 18:46:56'),
(4, 1, 1, 1, 1, 50, '2025-04-03 18:05:56', '2025-04-03 18:44:12'),
(11, 1, 1, 3, 1, 20, '2025-04-03 18:53:25', '2025-04-03 18:53:25'),
(12, 1, 1, 3, 1, 105, '2025-04-03 18:53:51', '2025-04-03 18:53:51'),
(13, 1, 4, 7, 1, 40, '2025-04-03 18:57:32', '2025-04-03 18:57:32'),
(14, 1, 3, 8, 1, 53, '2025-04-03 18:57:42', '2025-04-03 18:57:42'),
(15, 1, 6, 6, 1, 20, '2025-04-03 18:57:51', '2025-04-03 18:57:51'),
(16, 1, 4, 5, 1, 60, '2025-04-03 18:58:03', '2025-04-03 18:58:03'),
(17, 1, 5, 6, 1, 60, '2025-04-03 18:58:08', '2025-04-03 18:58:08'),
(18, 1, 4, 1, 1, 46, '2025-04-03 18:58:14', '2025-04-03 20:03:57');

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `candidatos`
--
ALTER TABLE `candidatos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_candidatos_elecciones_idx` (`id_eleccion`);

--
-- Indices de la tabla `centros`
--
ALTER TABLE `centros`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_localidad_nombre_unique` (`localidad`,`nombre_ie`);

--
-- Indices de la tabla `centros_votacion`
--
ALTER TABLE `centros_votacion`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_eleccion_centro_mesa_unique` (`id_eleccion`,`id_centro`,`numero_mesa`) COMMENT 'Una mesa específica en un centro para una elección debe ser única.',
  ADD KEY `fk_mesas_elecciones_idx` (`id_eleccion`),
  ADD KEY `fk_mesas_centros_idx` (`id_centro`);

--
-- Indices de la tabla `elecciones`
--
ALTER TABLE `elecciones`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nombre_usuario_UNIQUE` (`nombre_usuario`);

--
-- Indices de la tabla `votos`
--
ALTER TABLE `votos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_votos_elecciones_idx` (`id_eleccion`),
  ADD KEY `fk_votos_candidatos_idx` (`id_candidato`),
  ADD KEY `fk_votos_centros_votacion_idx` (`id_centro_votacion`),
  ADD KEY `fk_votos_usuarios_idx` (`id_usuario_registro`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `candidatos`
--
ALTER TABLE `candidatos`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT de la tabla `centros`
--
ALTER TABLE `centros`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT de la tabla `centros_votacion`
--
ALTER TABLE `centros_votacion`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID único para cada registro de mesa en una elección.', AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT de la tabla `elecciones`
--
ALTER TABLE `elecciones`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `votos`
--
ALTER TABLE `votos`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `candidatos`
--
ALTER TABLE `candidatos`
  ADD CONSTRAINT `fk_candidatos_elecciones` FOREIGN KEY (`id_eleccion`) REFERENCES `elecciones` (`id`) ON UPDATE CASCADE;

--
-- Filtros para la tabla `centros_votacion`
--
ALTER TABLE `centros_votacion`
  ADD CONSTRAINT `fk_mesas_centros` FOREIGN KEY (`id_centro`) REFERENCES `centros` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_mesas_elecciones` FOREIGN KEY (`id_eleccion`) REFERENCES `elecciones` (`id`) ON UPDATE CASCADE;

--
-- Filtros para la tabla `votos`
--
ALTER TABLE `votos`
  ADD CONSTRAINT `fk_votos_candidatos` FOREIGN KEY (`id_candidato`) REFERENCES `candidatos` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_votos_centros_votacion` FOREIGN KEY (`id_centro_votacion`) REFERENCES `centros_votacion` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_votos_elecciones` FOREIGN KEY (`id_eleccion`) REFERENCES `elecciones` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_votos_usuarios` FOREIGN KEY (`id_usuario_registro`) REFERENCES `usuarios` (`id`) ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
