<?php
// *** PROCESAMIENTO PHP ***
// Incluido por index.php, $pdo y $_SESSION disponibles.

$mensaje_exito = '';
$mensaje_error = '';
$id_eleccion_actual = DEFAULT_ELECTION_ID;
$id_usuario_actual = $_SESSION['user_id'];
$voto_a_editar = null; // Para guardar datos en modo edición de voto
$modo_edicion_voto = false; // Flag para edición de voto

// --- Mensajes de éxito/error por GET ---
if (isset($_GET['success'])) {
    switch ($_GET['success']) {
        case 'created': $mensaje_exito = "¡Registro de votos añadido exitosamente!"; break;
        case 'updated': $mensaje_exito = "¡Registro de votos actualizado exitosamente!"; break;
        case 'deleted': $mensaje_exito = "¡Registro de votos eliminado exitosamente!"; break;
    }
}
if (isset($_GET['error'])) {
     $mensaje_error = "Ocurrió un error: " . htmlspecialchars(urldecode($_GET['error']));
}

// --- DETECTAR MODO EDICIÓN DE VOTO (CARGAR DATOS) ---
if (isset($_GET['edit_vote_id'])) {
    $id_voto_para_editar = filter_input(INPUT_GET, 'edit_vote_id', FILTER_VALIDATE_INT);
    if ($id_voto_para_editar) {
        try {
            // Cargar el registro de voto específico
            $sql_edit = "SELECT id, id_candidato, id_centro_votacion, cantidad_votos
                         FROM votos
                         WHERE id = ? AND id_eleccion = ?"; // Asegurar que pertenece a la elección actual
            $q_edit = $pdo->prepare($sql_edit);
            $q_edit->execute([$id_voto_para_editar, $id_eleccion_actual]);
            $voto_a_editar = $q_edit->fetch(PDO::FETCH_ASSOC);

            if ($voto_a_editar) {
                $modo_edicion_voto = true;
            } else {
                header("Location: index.php?page=registro_votos&error=" . urlencode("Registro de voto no encontrado o no pertenece a esta elección."));
                exit;
            }
        } catch (PDOException $e) {
            error_log("Error al cargar voto para editar: " . $e->getMessage());
            $mensaje_error = "Error al cargar datos del registro de voto para edición.";
        }
    } else {
         header("Location: index.php?page=registro_votos&error=" . urlencode("ID de registro de voto inválido para editar."));
         exit;
    }
}

// --- PROCESAR ELIMINACIÓN DE VOTO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_id']) && isset($_POST['delete_type']) && $_POST['delete_type'] === 'voto') {
    $id_para_eliminar = filter_input(INPUT_POST, 'delete_id', FILTER_VALIDATE_INT);
    $error_url_param = '';

    if ($id_para_eliminar) {
        try {
            // Eliminar el registro específico de la tabla votos
            $sql_delete = "DELETE FROM votos WHERE id = ? AND id_eleccion = ?";
            $q_delete = $pdo->prepare($sql_delete);
            $q_delete->execute([$id_para_eliminar, $id_eleccion_actual]);

            if ($q_delete->rowCount() > 0) {
                header("Location: index.php?page=registro_votos&success=deleted");
                exit;
            } else {
                 $error_url_param = urlencode("No se encontró el registro de voto para eliminar (ID: $id_para_eliminar).");
            }
        } catch (PDOException $e) {
             error_log("Error PDO al eliminar registro de voto: " . $e->getMessage());
             $error_url_param = urlencode("Error de base de datos al eliminar el registro.");
        }
    } else {
        $error_url_param = urlencode("ID inválido para eliminar.");
    }
    header("Location: index.php?page=registro_votos&error=" . $error_url_param);
    exit;
}


// --- Carga de datos para los desplegables (Desde BD) ---
// (Misma lógica de carga que antes...)
$candidatos_disponibles = [];
$mesas_disponibles = [];
$error_carga_desplegables = false;
try {
    $sql_cand = "SELECT id, CONCAT(nombre, ' ', apellido, COALESCE(CONCAT(' (', partido_politico, ')'), ' (Indep.)')) AS nombre_completo FROM candidatos WHERE id_eleccion = ? ORDER BY apellido, nombre";
    $q_cand = $pdo->prepare($sql_cand); $q_cand->execute([$id_eleccion_actual]); $candidatos_disponibles = $q_cand->fetchAll(PDO::FETCH_ASSOC);
    $sql_mesas = "SELECT cv.id, CONCAT(c.localidad, ' - ', c.nombre_ie, ' - Mesa: ', cv.numero_mesa) AS descripcion FROM centros_votacion cv JOIN centros c ON cv.id_centro = c.id WHERE cv.id_eleccion = ? ORDER BY c.localidad, c.nombre_ie, cv.numero_mesa";
    $q_mesas = $pdo->prepare($sql_mesas); $q_mesas->execute([$id_eleccion_actual]); $mesas_disponibles = $q_mesas->fetchAll(PDO::FETCH_ASSOC);
    if (empty($candidatos_disponibles) || empty($mesas_disponibles)) { $error_carga_desplegables = true; }
} catch (PDOException $e) { error_log("Error cargando desplegables: " . $e->getMessage()); $mensaje_error = "Error crítico al cargar candidatos/mesas."; $error_carga_desplegables = true; }


// --- Procesamiento del Formulario (Añadir o Actualizar Voto específico) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['registrar_votos']) && !$error_carga_desplegables) {
    $id_voto_especifico = filter_input(INPUT_POST, 'votos_id', FILTER_VALIDATE_INT); // ID si es actualización
    $id_candidato = filter_input(INPUT_POST, 'id_candidato', FILTER_VALIDATE_INT);
    $id_mesa = filter_input(INPUT_POST, 'id_mesa_votacion', FILTER_VALIDATE_INT);
    $cantidad_votos_input = filter_input(INPUT_POST, 'cantidad_votos', FILTER_SANITIZE_NUMBER_INT);
    $cantidad_votos = filter_var($cantidad_votos_input, FILTER_VALIDATE_INT, ['options' => ['min_range' => 0]]);

    if ($id_candidato === false || $id_mesa === false || $cantidad_votos === false) {
         $mensaje_error = "Datos inválidos. Verifique el candidato, la mesa y la cantidad de votos (debe ser 0 o más).";
    }
    elseif (!in_array($id_candidato, array_column($candidatos_disponibles, 'id')) || !in_array($id_mesa, array_column($mesas_disponibles, 'id'))) {
         $mensaje_error = "El candidato o la mesa seleccionada no es válida para esta elección.";
    }
    else {
        try {
            if ($id_voto_especifico) { // --- ACTUALIZAR REGISTRO ESPECÍFICO ---
                 $sql_update = "UPDATE votos
                                SET id_candidato = ?, id_centro_votacion = ?, cantidad_votos = ?,
                                    id_usuario_registro = ?, updated_at = NOW()
                                WHERE id = ? AND id_eleccion = ?";
                 $q_update = $pdo->prepare($sql_update);
                 if($q_update->execute([$id_candidato, $id_mesa, $cantidad_votos, $id_usuario_actual, $id_voto_especifico, $id_eleccion_actual])) {
                     header("Location: index.php?page=registro_votos&success=updated");
                     exit;
                 } else {
                     $mensaje_error = "No se pudo actualizar el registro de votos.";
                 }

            } else { // --- INSERTAR NUEVO REGISTRO ---
                 // Ya no usamos ON DUPLICATE KEY UPDATE
                 $sql_insert = "INSERT INTO votos
                                    (id_eleccion, id_candidato, id_centro_votacion, id_usuario_registro, cantidad_votos, timestamp_registro, updated_at)
                               VALUES (?, ?, ?, ?, ?, NOW(), NOW())";
                $q_insert = $pdo->prepare($sql_insert);
                if($q_insert->execute([$id_eleccion_actual, $id_candidato, $id_mesa, $id_usuario_actual, $cantidad_votos])) {
                    header("Location: index.php?page=registro_votos&success=created");
                    exit;
                } else {
                     $mensaje_error = "No se pudo añadir el nuevo registro de votos.";
                }
            }

        } catch (PDOException $e) {
            error_log("Error al registrar/actualizar votos: " . $e->getMessage());
            $mensaje_error = "Error al procesar el registro de votos en la base de datos.";
        }
    }
     // Si hubo error, asegurar que seguimos en modo edición si aplica
     if (!empty($mensaje_error) && $id_voto_especifico) {
         $modo_edicion_voto = true;
         // Recargar datos originales (o usar los del POST si prefieres mantener intento)
         $sql_reload = "SELECT id, id_candidato, id_centro_votacion, cantidad_votos FROM votos WHERE id = ?";
         $q_reload = $pdo->prepare($sql_reload); $q_reload->execute([$id_voto_especifico]);
         $voto_a_editar = $q_reload->fetch(PDO::FETCH_ASSOC);
         // Mantener los valores que el usuario intentó enviar si falló
         $voto_a_editar['id_candidato'] = $_POST['id_candidato'] ?? $voto_a_editar['id_candidato'];
         $voto_a_editar['id_centro_votacion'] = $_POST['id_mesa_votacion'] ?? $voto_a_editar['id_centro_votacion'];
         $voto_a_editar['cantidad_votos'] = $_POST['cantidad_votos'] ?? $voto_a_editar['cantidad_votos'];
     }
}

// --- Cargar Últimos Registros (ACTIVO) ---
// (Misma lógica de carga que antes, ordenada por updated_at DESC)
$ultimos_votos = [];
$error_carga_ultimos = null;
try {
    $sql_ultimos = "SELECT v.id, CONCAT(ca.nombre, ' ', ca.apellido) AS candidato, CONCAT(c.localidad, ' - ', c.nombre_ie, ' - Mesa: ', cv.numero_mesa) AS mesa, v.cantidad_votos, u.nombre_usuario AS registrado_por, v.timestamp_registro, v.updated_at FROM votos v JOIN candidatos ca ON v.id_candidato = ca.id JOIN centros_votacion cv ON v.id_centro_votacion = cv.id JOIN centros c ON cv.id_centro = c.id JOIN usuarios u ON v.id_usuario_registro = u.id WHERE v.id_eleccion = ? ORDER BY v.updated_at DESC LIMIT 10";
    $q_ultimos = $pdo->prepare($sql_ultimos); $q_ultimos->execute([$id_eleccion_actual]); $ultimos_votos = $q_ultimos->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) { error_log("Error cargando últimos votos: " . $e->getMessage()); $error_carga_ultimos = "No se pudieron cargar los últimos registros."; }

?>

<div class="container-fluid">
    <!-- Título cambia si estamos editando -->
    <h1 class="mb-4">
        <i class="fas fa-<?php echo $modo_edicion_voto ? 'pencil-alt' : 'edit'; ?>"></i>
        <?php echo $modo_edicion_voto ? 'Editar Registro de Voto' : 'Registro de Votos'; ?>
        (Elección ID: <?php echo $id_eleccion_actual; ?>)
    </h1>

    <!-- Área de mensajes -->
    <?php if ($mensaje_exito): ?><div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($mensaje_exito); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php endif; ?>
    <?php if ($mensaje_error): ?><div class="alert alert-danger alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($mensaje_error); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php endif; ?>

    <!-- Formulario para registrar/editar votos -->
    <?php if ($error_carga_desplegables): ?>
        <div class="alert alert-danger">Error crítico: No se pudo cargar la información de candidatos o mesas. El formulario está deshabilitado.</div>
    <?php else: ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary"><?php echo $modo_edicion_voto ? 'Modificar Datos del Registro ID: ' . htmlspecialchars($voto_a_editar['id']) : 'Ingresar Nuevo Registro de Votos'; ?></h6></div>
            <div class="card-body">
                 <?php if (!$modo_edicion_voto): // Mostrar texto explicativo solo al añadir ?>
                <p class="text-muted small">Seleccione el candidato, la mesa e ingrese la cantidad de votos para este registro. Puede añadir múltiples registros para la misma combinación.</p>
                 <?php endif; ?>
                <form action="index.php?page=registro_votos<?php echo $modo_edicion_voto ? '&edit_vote_id='.htmlspecialchars($voto_a_editar['id']) : ''; ?>" method="POST">
                    <!-- ID oculto solo en modo edición -->
                    <?php if ($modo_edicion_voto): ?>
                        <input type="hidden" name="votos_id" value="<?php echo htmlspecialchars($voto_a_editar['id']); ?>">
                    <?php endif; ?>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="id_candidato" class="form-label">Candidato: <span class="text-danger">*</span></label>
                            <select class="form-select" id="id_candidato" name="id_candidato" required>
                                <option value="" <?php echo !$modo_edicion_voto ? 'selected' : ''; ?> disabled>-- Seleccione Candidato --</option>
                                <?php foreach ($candidatos_disponibles as $candidato): ?>
                                    <option value="<?php echo htmlspecialchars($candidato['id']); ?>"
                                        <?php if ($modo_edicion_voto && $voto_a_editar['id_candidato'] == $candidato['id']) echo 'selected'; ?>>
                                        <?php echo htmlspecialchars($candidato['nombre_completo']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="id_mesa_votacion" class="form-label">Centro / Mesa: <span class="text-danger">*</span></label>
                            <select class="form-select" id="id_mesa_votacion" name="id_mesa_votacion" required>
                                <option value="" <?php echo !$modo_edicion_voto ? 'selected' : ''; ?> disabled>-- Seleccione Localidad - IE - Mesa --</option>
                                <?php foreach ($mesas_disponibles as $mesa): ?>
                                    <option value="<?php echo htmlspecialchars($mesa['id']); ?>"
                                        <?php if ($modo_edicion_voto && $voto_a_editar['id_centro_votacion'] == $mesa['id']) echo 'selected'; ?>>
                                        <?php echo htmlspecialchars($mesa['descripcion']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3 justify-content-center">
                        <div class="col-md-4">
                            <label for="cantidad_votos" class="form-label">Cantidad de Votos: <span class="text-danger">*</span></label>
                            <input type="number" class="form-control <?php echo (strpos($mensaje_error, 'cantidad de votos') !== false) ? 'is-invalid' : '';?>"
                                   id="cantidad_votos" name="cantidad_votos" min="0" required placeholder="Ingrese el total (puede ser 0)"
                                   value="<?php echo htmlspecialchars($voto_a_editar['cantidad_votos'] ?? ($_POST['cantidad_votos'] ?? '')); ?>">
                        </div>
                    </div>
                    <input type="hidden" name="registrar_votos" value="1">
                    <div class="text-center">
                         <button type="submit" class="btn btn-<?php echo $modo_edicion_voto ? 'warning' : 'success'; ?> me-2">
                            <i class="fas fa-<?php echo $modo_edicion_voto ? 'save' : 'check'; ?>"></i> <?php echo $modo_edicion_voto ? 'Guardar Cambios' : 'Añadir Registro'; ?>
                        </button>
                         <?php if ($modo_edicion_voto): ?>
                            <a href="index.php?page=registro_votos" class="btn btn-secondary"><i class="fas fa-times"></i> Cancelar Edición</a>
                         <?php else: ?>
                            <button type="reset" class="btn btn-secondary"><i class="fas fa-eraser"></i> Limpiar</button>
                         <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>

    <!-- Tabla de Últimos Registros -->
    <div class="card shadow mb-4">
        <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary">Últimos 10 Registros Añadidos/Modificados</h6></div>
        <div class="card-body">
             <?php if ($error_carga_ultimos): ?>
                 <div class="alert alert-warning text-center"><?php echo htmlspecialchars($error_carga_ultimos); ?></div>
             <?php elseif (!empty($ultimos_votos)): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover table-sm" width="100%" cellspacing="0">
                        <thead class="table-light">
                            <tr>
                                <th>ID</th>
                                <th>Candidato</th>
                                <th>Centro/Mesa</th>
                                <th class="text-end">Cantidad</th>
                                <th>Usuario</th>
                                <th>Registro</th>
                                <th>Modificación</th>
                                <th class="text-center">Acciones</th> <!-- Nueva columna -->
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($ultimos_votos as $voto):
                                $nombre_descriptivo_voto = "Registro ID: " . htmlspecialchars($voto['id']) . " (" . htmlspecialchars($voto['candidato']) . " - " . number_format($voto['cantidad_votos']) . " votos)";
                            ?>
                            <tr>
                                <td><?php echo htmlspecialchars($voto['id']); ?></td>
                                <td><?php echo htmlspecialchars($voto['candidato']); ?></td>
                                <td><?php echo htmlspecialchars($voto['mesa']); ?></td>
                                <td class="text-end"><?php echo number_format($voto['cantidad_votos']); ?></td>
                                <td><?php echo htmlspecialchars($voto['registrado_por']); ?></td>
                                <td><?php echo htmlspecialchars(date('d/m/y H:i', strtotime($voto['timestamp_registro']))); ?></td>
                                <td><?php echo htmlspecialchars(date('d/m/y H:i', strtotime($voto['updated_at']))); ?></td>
                                <td class="text-center align-middle"> <!-- Botones Editar/Eliminar -->
                                     <a href="index.php?page=registro_votos&edit_vote_id=<?php echo htmlspecialchars($voto['id']); ?>" class="btn btn-sm btn-warning me-1 py-0 px-1" title="Editar este registro">
                                            <i class="fas fa-pencil-alt fa-xs"></i>
                                     </a>
                                     <button type="button" class="btn btn-sm btn-danger py-0 px-1" title="Eliminar este registro"
                                                data-bs-toggle="modal" data-bs-target="#confirmDeleteModal"
                                                data-id="<?php echo htmlspecialchars($voto['id']); ?>"
                                                data-name="<?php echo $nombre_descriptivo_voto; ?>"
                                                data-type="voto"
                                                data-page="registro_votos">
                                            <i class="fas fa-trash fa-xs"></i>
                                      </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-center text-muted">Aún no hay registros de votos para mostrar para esta elección.</p>
            <?php endif; ?>
        </div>
    </div>

</div> <!-- Fin container-fluid -->