<?php
// Incluir archivos necesarios una sola vez
require_once 'config.php';
require_once 'includes/database.php';

session_start(); // Iniciar la sesión ANTES de cualquier salida HTML

// Si el usuario ya está logueado, redirigir al dashboard
if (isset($_SESSION['user_id'])) {
    header('Location: index.php'); // Redirige a la página principal del dashboard
    exit;
}

// --- Variables para Mensajes ---
$error_login = '';

// --- Procesamiento del Login ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['username']) && isset($_POST['password'])) {
    $usuario_ingresado = trim($_POST['username']); // Usar trim para quitar espacios extra
    $password_ingresada = $_POST['password'];

    if (empty($usuario_ingresado) || empty($password_ingresada)) {
        $error_login = 'Por favor, ingrese usuario y contraseña.';
    } else {
        try {
            $pdo = Database::connect();
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $sql = "SELECT id, nombre_usuario, password, rol, activo FROM usuarios WHERE nombre_usuario = ? LIMIT 1";
            $q = $pdo->prepare($sql);
            $q->execute([$usuario_ingresado]);
            $usuario_db = $q->fetch(PDO::FETCH_ASSOC);

            if ($usuario_db) {
                // Verificar si el usuario está activo
                if ($usuario_db['activo'] == 1) {
                    // ¡¡Verificar la contraseña hasheada!!
                    if (password_verify($password_ingresada, $usuario_db['password'])) {
                        // --- Inicio de sesión exitoso ---
                        session_regenerate_id(true); // Regenerar ID de sesión por seguridad
                        $_SESSION['user_id'] = $usuario_db['id'];
                        $_SESSION['username'] = $usuario_db['nombre_usuario'];
                        $_SESSION['role'] = $usuario_db['rol'];

                        Database::disconnect();
                        // Redirigir al dashboard
                        header('Location: index.php?page=home');
                        exit;
                    } else {
                        // Contraseña incorrecta
                        $error_login = 'Nombre de usuario o contraseña incorrectos.';
                    }
                } else {
                    // Usuario inactivo
                    $error_login = 'Su cuenta de usuario está desactivada.';
                }
            } else {
                // Usuario no encontrado
                $error_login = 'Nombre de usuario o contraseña incorrectos.';
            }
            Database::disconnect();
        } catch (PDOException $e) {
            error_log("Error en login: " . $e->getMessage());
            $error_login = 'Error al intentar iniciar sesión. Intente más tarde.';
        }
    }
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistema de Votos</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body { background-color: #f0f2f5; }
        .login-container { min-height: 100vh; display: flex; align-items: center; justify-content: center; }
        .login-card { border-radius: 1rem; overflow: hidden; }
        .login-image { object-fit: cover; height: 100%; width: 100%; }
        .login-form-col { background-color: #ffffff; display: flex; flex-direction: column; justify-content: center; }
        .social-login i { transition: color 0.2s; }
        .social-login a:hover i.fa-google { color: #DB4437; }
        .social-login a:hover i.fa-facebook-f { color: #4267B2; }
        .social-login a:hover i.fa-twitter { color: #1DA1F2; }
        @media (max-width: 767.98px) { .login-image-col { display: none; } .login-form-col { border-radius: 1rem; } }
    </style>
</head>
<body>

<div class="container login-container">
    <div class="col-lg-10 col-xl-9 mx-auto">
        <div class="card flex-row mx-auto mx-md-0 login-card shadow-lg">
            <div class="col-md-6 d-none d-md-block login-image-col p-0">
                <img src="assets/login-bg.jpg" alt="Imagen Electoral" class="login-image">
            </div>
            <div class="col-md-6 login-form-col p-4 p-lg-5">
                <div class="w-100">
                    <div class="text-center mb-4">
                        <i class="fas fa-vote-yea fa-3x text-primary mb-2"></i>
                        <h4 class="fw-bold">Sistema Votos</h4>
                        <p class="text-muted">Iniciar Sesión</p>
                    </div>

                    <?php if ($error_login): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            <?php echo htmlspecialchars($error_login); ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <form action="login.php" method="POST">
                        <div class="form-floating mb-3">
                            <input type="text" class="form-control" id="username" name="username" placeholder="Usuario" required autofocus value="<?php echo isset($_POST['username']) ? htmlspecialchars($_POST['username']) : ''; ?>">
                            <label for="username"><i class="fas fa-user me-2"></i>Nombre de Usuario</label>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="password" class="form-control" id="password" name="password" placeholder="Contraseña" required>
                            <label for="password"><i class="fas fa-lock me-2"></i>Contraseña</label>
                        </div>
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" value="" id="rememberMe">
                            <label class="form-check-label" for="rememberMe"> Recordarme </label>
                        </div>
                        <div class="d-grid mb-3">
                            <button class="btn btn-lg btn-primary fw-bold" type="submit">
                                <i class="fas fa-sign-in-alt me-2"></i>Entrar
                            </button>
                        </div>
                        <div class="text-center">
                            <a class="small" href="#">¿Olvidaste tu contraseña?</a>
                        </div>
                        <hr class="my-4">
                        <p class="text-center text-muted small mb-2">O inicia sesión con:</p>
                        <div class="text-center social-login">
                             <a href="#" class="text-secondary mx-2" title="Login con Google"><i class="fab fa-google fa-2x"></i></a>
                             <a href="#" class="text-secondary mx-2" title="Login con Facebook"><i class="fab fa-facebook-f fa-2x"></i></a>
                             <a href="#" class="text-secondary mx-2" title="Login con Twitter"><i class="fab fa-twitter fa-2x"></i></a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>