<?php
// 1. Iniciar sesión y verificar login
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) { header('Location: ../index.php?error=not_logged_in'); exit; }

// 2. Incluir conexión BD
require_once '../config/db.php';

// --- Lógica de Roles ---
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'usuario';
$current_user_id = $_SESSION['user_id']; // ID del usuario logueado

// --- ACCESO SOLO ADMIN ---
if ($user_role !== 'administrador') {
    // Si no es admin, redirigir al dashboard (o mostrar error)
    $_SESSION['access_error'] = "No tienes permiso para acceder a esta sección.";
    header('Location: ../dashboard.php');
    exit;
}
// ------------------------

// 3. Obtener usuarios
$usuarios = [];
$error_db = null;
try {
    // Excluir al usuario actual si se quisiera, aunque no es estrictamente necesario aquí
    $stmt = $pdo->query("SELECT id, username, nombre_completo, rol, activo FROM usuarios ORDER BY username");
    $usuarios = $stmt->fetchAll();
} catch (PDOException $e) {
    error_log("Error al obtener usuarios: " . $e->getMessage());
    $error_db = "No se pudieron cargar los usuarios. Error: " . $e->getCode();
}

// 4. Datos usuario navbar
$username = isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Usuario';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Usuarios - SysVehiculos</title>
    <!-- CSS / Font Awesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="../css/style.css">
     
     <!-- === FAVICON === -->
    <!-- Ruta relativa desde la raíz a la carpeta img/ -->
    <link rel="icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <!-- Opcional: Si tienes un apple-touch-icon.png en /img/ -->
    <!-- <link rel="apple-touch-icon" href="img/apple-touch-icon.png"> -->
    <!-- ============= -->
     
     <style>
        .status-activo { color: #198754; } /* Verde Bootstrap */
        .status-inactivo { color: #dc3545; } /* Rojo Bootstrap */
        .action-link { text-decoration: none; cursor: pointer;} /* Para botones de estado */
    </style>
</head>
<body class="dashboard-page">
    <div class="d-flex" id="wrapper">
        <!-- Sidebar (Usando el include) -->
        <?php require_once '../includes/sidebar.php'; ?>

        <!-- Page Content -->
        <div id="page-content-wrapper">
            <nav class="navbar navbar-expand-lg navbar-light bg-light border-bottom">
                 <!-- ... (contenido navbar igual) ... -->
                 <div class="container-fluid">
                    <button class="btn btn-primary btn-sm" id="sidebarToggle"><i class="fas fa-align-left"></i></button>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"> <span class="navbar-toggler-icon"></span> </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav ms-auto mt-2 mt-lg-0">
                            <li class="nav-item me-2"> <button class="btn btn-sm theme-toggle-btn-nav"> <i class="fas fa-moon"></i> <span class="d-none d-sm-inline">Tema</span> </button> </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown"> <i class="fas fa-user me-1"></i> <?php echo $username; ?> </a>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="#!">Mi Perfil</a> <a class="dropdown-item" href="#!">Configuración</a>
                                    <div class="dropdown-divider"></div> <a class="dropdown-item text-danger" href="../logout.php">Cerrar Sesión</a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>

            <!-- Contenido Principal de Usuarios -->
            <div class="container-fluid px-4">
                <h1 class="mt-4">Gestión de Usuarios</h1>
                <p>Administra los usuarios del sistema.</p>

                 <div class="d-flex justify-content-between align-items-center mb-3">
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalUsuario" id="btnAgregarUsuario">
                        <i class="fas fa-user-plus me-1"></i> Agregar Usuario
                    </button>
                 </div>

                 <!-- Buscador Usuarios -->
                 <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="search" id="searchUsuarioInput" class="form-control" placeholder="Buscar por Usuario o Nombre..." aria-label="Buscar Usuario">
                            <button class="btn btn-outline-secondary" type="button" id="searchUsuarioButton"> <i class="fas fa-search"></i> Buscar </button>
                        </div>
                    </div>
                 </div>

                 <!-- Mensajes -->
                 <?php /* ... (código mensajes igual) ... */ ?>
                 <?php if ($error_db): ?><div class="alert alert-danger"><?php echo htmlspecialchars($error_db); ?></div><?php endif; ?>
                 <?php if (isset($_SESSION['form_success'])): ?><div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($_SESSION['form_success']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php unset($_SESSION['form_success']); ?><?php endif; ?>
                 <?php if (isset($_SESSION['form_error'])): ?><div class="alert alert-danger alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($_SESSION['form_error']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php unset($_SESSION['form_error']); ?><?php endif; ?>
                 <?php if (isset($_SESSION['access_error'])): ?><div class="alert alert-warning"><?php echo htmlspecialchars($_SESSION['access_error']); ?></div><?php unset($_SESSION['access_error']); ?><?php endif; ?>


                 <!-- Tabla de Usuarios -->
                 <div class="card mb-4">
                    <div class="card-header"> <i class="fas fa-users me-1"></i> Listado de Usuarios </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover table-bordered" id="tablaUsuarios">
                                <thead class="table-dark">
                                    <tr>
                                        <th>#</th>
                                        <th>Usuario</th>
                                        <th>Nombre Completo</th>
                                        <th>Rol</th>
                                        <th>Estado</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tablaUsuariosBody">
                                    <?php if (empty($usuarios)): ?>
                                        <tr id="noDataUsuarioRow"> <td colspan="6" class="text-center">No hay usuarios registrados.</td> </tr>
                                    <?php else: ?>
                                        <?php $countUser = 1; ?>
                                        <?php foreach ($usuarios as $user): ?>
                                            <tr>
                                                <td><?php echo $countUser++; ?></td>
                                                <td><?php echo htmlspecialchars($user['username']); ?></td>
                                                <td><?php echo htmlspecialchars($user['nombre_completo'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars(ucfirst($user['rol'])); // Poner primera letra en mayúscula ?></td>
                                                <td>
                                                    <?php if ($user['activo']): ?>
                                                        <span class="badge bg-success status-activo">Activo</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-danger status-inactivo">Inactivo</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-warning btnEditarUsuario"
                                                            data-bs-toggle="modal" data-bs-target="#modalUsuario"
                                                            data-id="<?php echo $user['id']; ?>"
                                                            data-username="<?php echo htmlspecialchars($user['username']); ?>"
                                                            data-nombre="<?php echo htmlspecialchars($user['nombre_completo'] ?? ''); ?>"
                                                            data-rol="<?php echo htmlspecialchars($user['rol']); ?>"
                                                            title="Editar Usuario">
                                                        <i class="fas fa-edit"></i>
                                                    </button>

                                                    <!-- Botón Toggle Estado -->
                                                    <?php if ($user['id'] !== $current_user_id): // No se puede desactivar a sí mismo ?>
                                                        <button type="button" class="btn btn-sm btnToggleEstado <?php echo $user['activo'] ? 'btn-secondary' : 'btn-info'; ?>"
                                                                data-id="<?php echo $user['id']; ?>"
                                                                data-estado="<?php echo $user['activo'] ? '1' : '0'; ?>"
                                                                title="<?php echo $user['activo'] ? 'Desactivar' : 'Activar'; ?>">
                                                            <i class="fas <?php echo $user['activo'] ? 'fa-toggle-off' : 'fa-toggle-on'; ?>"></i>
                                                        </button>
                                                    <?php endif; ?>


                                                    <?php if ($user_role === 'administrador' && $user['id'] !== $current_user_id): // No se puede eliminar a sí mismo ?>
                                                        <button type="button" class="btn btn-sm btn-danger btnEliminarUsuario"
                                                                data-id="<?php echo $user['id']; ?>"
                                                                data-username="<?php echo htmlspecialchars($user['username']); ?>"
                                                                title="Eliminar Usuario">
                                                            <i class="fas fa-trash-alt"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                    <tr id="noResultsRowUsuario" style="display: none;"> <td colspan="6" class="text-center text-muted">No se encontraron usuarios.</td> </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div> <!-- /container-fluid -->
        </div> <!-- /#page-content-wrapper -->
    </div> <!-- /#wrapper -->

    <!-- Modal para Agregar/Editar Usuario -->
    <div class="modal fade" id="modalUsuario" tabindex="-1" aria-labelledby="modalUsuarioLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalUsuarioLabel">Agregar Usuario</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="formUsuario" method="POST" action="../controllers/usuario_controller.php">
                        <input type="hidden" name="usuario_id" id="usuario_id" value="0">
                        <input type="hidden" name="accion" id="accionUsuario" value="agregar">

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="usernameUsuario" class="form-label">Nombre de Usuario <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="usernameUsuario" name="username" required autocomplete="off">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="nombreCompletoUsuario" class="form-label">Nombre Completo</label>
                                <input type="text" class="form-control" id="nombreCompletoUsuario" name="nombre_completo">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                 <label for="rolUsuario" class="form-label">Rol <span class="text-danger">*</span></label>
                                 <select class="form-select" id="rolUsuario" name="rol" required>
                                     <option value="" disabled selected>Selecciona un rol...</option>
                                     <option value="usuario">Usuario</option>
                                     <option value="administrador">Administrador</option>
                                 </select>
                            </div>
                        </div>
                         <hr>
                         <h6>Contraseña</h6>
                         <p class="small text-muted" id="passwordHelp">Dejar en blanco si no deseas cambiar la contraseña al editar.</p>
                         <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="passwordUsuario" class="form-label">Contraseña</label>
                                <input type="password" class="form-control" id="passwordUsuario" name="password" autocomplete="new-password">
                                <div class="invalid-feedback">Las contraseñas no coinciden.</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="passwordConfirmUsuario" class="form-label">Confirmar Contraseña</label>
                                <input type="password" class="form-control" id="passwordConfirmUsuario" name="password_confirm">
                             </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary" form="formUsuario">Guardar Usuario</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../js/script.js"></script>

    <!-- Script específico para Usuarios -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // --- Selectores ---
            const modalUsuario = new bootstrap.Modal(document.getElementById('modalUsuario'));
            const formUsuario = document.getElementById('formUsuario');
            const modalTitleUser = document.getElementById('modalUsuarioLabel');
            const usuarioIdInput = document.getElementById('usuario_id');
            const accionInputUser = document.getElementById('accionUsuario');
            const usernameInput = document.getElementById('usernameUsuario');
            const nombreCompletoInput = document.getElementById('nombreCompletoUsuario');
            const rolSelect = document.getElementById('rolUsuario');
            const passwordInput = document.getElementById('passwordUsuario');
            const passwordConfirmInput = document.getElementById('passwordConfirmUsuario');
            const passwordHelp = document.getElementById('passwordHelp');
            const tablaBodyUser = document.getElementById('tablaUsuariosBody');
            const searchInputUser = document.getElementById('searchUsuarioInput');
            const searchButtonUser = document.getElementById('searchUsuarioButton');
            const noResultsRowUser = document.getElementById('noResultsRowUsuario');
            const noDataRowUser = document.getElementById('noDataUsuarioRow');

            // --- Reset Modal ---
            function resetModalUsuario() {
                modalTitleUser.textContent = 'Agregar Usuario';
                formUsuario.reset();
                usuarioIdInput.value = '0';
                accionInputUser.value = 'agregar';
                passwordInput.required = true; // Contraseña requerida al agregar
                passwordConfirmInput.required = true;
                passwordInput.classList.remove('is-invalid'); // Limpiar validación
                passwordConfirmInput.classList.remove('is-invalid');
                passwordHelp.style.display = 'none'; // Ocultar ayuda pass
                usernameInput.readOnly = false; // Permitir editar username al agregar
                formUsuario.classList.remove('was-validated');
            }

            // --- Lógica Modal ---
            document.getElementById('btnAgregarUsuario')?.addEventListener('click', resetModalUsuario);

            tablaBodyUser.addEventListener('click', function(event) {
                const target = event.target.closest('.btnEditarUsuario');
                if (target) {
                    resetModalUsuario(); // Limpia primero
                    modalTitleUser.textContent = 'Editar Usuario';
                    usuarioIdInput.value = target.dataset.id;
                    accionInputUser.value = 'editar';
                    usernameInput.value = target.dataset.username;
                    usernameInput.readOnly = true; // NO permitir editar username
                    nombreCompletoInput.value = target.dataset.nombre;
                    rolSelect.value = target.dataset.rol;
                    passwordInput.required = false; // Contraseña NO requerida al editar
                    passwordConfirmInput.required = false;
                    passwordHelp.style.display = 'block'; // Mostrar ayuda pass
                }
            });

            // --- Validación Contraseñas ---
            function validatePasswords() {
                 passwordInput.classList.remove('is-invalid');
                 passwordConfirmInput.classList.remove('is-invalid');
                 if (passwordInput.value !== passwordConfirmInput.value) {
                     passwordInput.classList.add('is-invalid');
                     passwordConfirmInput.classList.add('is-invalid');
                     return false;
                 }
                 return true;
            }
             passwordConfirmInput.addEventListener('input', validatePasswords);
             passwordInput.addEventListener('input', validatePasswords); // Validar también al cambiar la primera

             // --- Validación Submit Modal ---
             formUsuario.addEventListener('submit', function (event) {
                 let passwordsValid = true;
                 // Validar contraseñas solo si se está agregando o si se escribió algo en editar
                 if (accionInputUser.value === 'agregar' || passwordInput.value !== '') {
                    passwordsValid = validatePasswords();
                 }

                 if (!formUsuario.checkValidity() || !passwordsValid) {
                   event.preventDefault();
                   event.stopPropagation();
                 }
                 formUsuario.classList.add('was-validated');
             }, false);


            // --- Lógica Toggle Estado y Eliminar (con forms dinámicos) ---
             function submitActionForm(userId, action) {
                const formAction = document.createElement('form');
                formAction.method = 'POST';
                formAction.action = '../controllers/usuario_controller.php';

                const idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.name = 'usuario_id';
                idInput.value = userId;
                formAction.appendChild(idInput);

                const actionInput = document.createElement('input');
                actionInput.type = 'hidden';
                actionInput.name = 'accion';
                actionInput.value = action;
                formAction.appendChild(actionInput);

                document.body.appendChild(formAction);
                formAction.submit();
            }

            tablaBodyUser.addEventListener('click', function(event) {
                const targetToggle = event.target.closest('.btnToggleEstado');
                const targetDelete = event.target.closest('.btnEliminarUsuario');

                if (targetToggle) {
                    const userId = targetToggle.dataset.id;
                    const estadoActual = targetToggle.dataset.estado === '1' ? 'desactivar' : 'activar';
                    if (confirm(`¿Estás seguro de que deseas ${estadoActual} a este usuario (ID: ${userId})?`)) {
                         submitActionForm(userId, 'toggle_status');
                    }
                } else if (targetDelete) {
                     const userId = targetDelete.dataset.id;
                     const userUsername = targetDelete.dataset.username;
                     if (confirm(`¿Estás seguro de que deseas eliminar al usuario "${userUsername}" (ID: ${userId})? Esta acción no se puede deshacer.`)) {
                         submitActionForm(userId, 'eliminar');
                     }
                }
            });


            // --- Lógica Búsqueda Tabla Usuarios ---
             function performUsuarioSearch() {
                 const searchTerm = searchInputUser.value.toLowerCase().trim();
                 const rows = tablaBodyUser.querySelectorAll('tr:not(#noResultsRowUsuario):not(#noDataUsuarioRow)');
                 let resultsFound = false;
                 rows.forEach(row => {
                     const username = row.cells[1]?.textContent.toLowerCase() || '';
                     const nombreCompleto = row.cells[2]?.textContent.toLowerCase() || '';
                     if (username.includes(searchTerm) || nombreCompleto.includes(searchTerm)) {
                         row.style.display = ''; resultsFound = true;
                     } else {
                         row.style.display = 'none';
                     }
                 });
                 noResultsRowUser.style.display = resultsFound ? 'none' : '';
                 if (noDataRowUser) { noDataRowUser.style.display = (searchTerm === '' && <?php echo empty($usuarios) ? 'true' : 'false'; ?>) ? '' : 'none'; }
                 if (searchTerm === '') { rows.forEach(row => row.style.display = ''); noResultsRowUser.style.display = 'none'; }
             }
             searchButtonUser.addEventListener('click', performUsuarioSearch);
             searchInputUser.addEventListener('keypress', function(event) { if (event.key === 'Enter') { event.preventDefault(); performUsuarioSearch(); } });

        }); // Fin DOMContentLoaded
    </script>
</body>
</html>