<?php
// 1. Iniciar sesión y verificar login (AL PRINCIPIO DE TODO)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: ../index.php?error=not_logged_in'); // Correcto: Salir de views a index.php
    exit;
}

// 2. Incluir archivo de conexión a la BD (Verificar ruta)
// Esto debe definir la variable $pdo
require_once '../config/db.php'; // Correcto: Salir de views a config/

// --- Lógica de Roles (Definir ANTES de incluir sidebar) ---
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'usuario';
$current_user_id = $_SESSION['user_id']; // ID del usuario logueado (útil para sidebar o lógica futura)
// $user_role = 'administrador'; // Descomentar solo para probar la vista de admin
// -----------------------------------------------------------

// 3. Obtener propietarios (Incluyendo telefono)
$propietarios = [];
$error_db = null;
try {
    // Asegúrate que $pdo está definido por db.php
    if (!isset($pdo)) {
         throw new Exception("Error: La conexión a la base de datos (PDO) no está definida. Revisa 'config/db.php'.");
    }
    $stmt = $pdo->query("SELECT id, nombre, apellido, dni, direccion, provincia, distrito, telefono FROM propietarios ORDER BY apellido, nombre");
    $propietarios = $stmt->fetchAll();
} catch (PDOException $e) {
    error_log("Error PDO al obtener propietarios: " . $e->getMessage());
    $error_db = "No se pudieron cargar los propietarios (Error DB: " . $e->getCode() . ")";
} catch (Exception $e) { // Capturar otros errores (como el de $pdo indefinido)
    error_log("Error general al obtener propietarios: " . $e->getMessage());
    $error_db = $e->getMessage(); // Mostrar mensaje de error personalizado
}


// 4. Preparar datos del usuario logueado para la navbar
$username = isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Usuario';

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Propietarios - SysVehiculos</title>

    <!-- CSS y Font Awesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- Favicon principal para la mayoría de navegadores -->
    <link rel="icon" href="img/favicon.ico" sizes="any"> <!-- Busca .ico en la raíz -->
    <!-- Alternativa SVG (si tienes uno) -->
    <!-- <link rel="icon" href="/img/logo.svg" type="image/svg+xml"> -->
    <!-- Icono para dispositivos Apple (180x180 recomendado) -->
    <link rel="apple-touch-icon" href="/img/apple-touch-icon.png"> <!-- Asume que está en /img/ -->
    <!-- Opcional: Manifiesto para PWA/Android -->
    <!-- <link rel="manifest" href="/manifest.webmanifest"> -->
     
    <!-- Ruta CSS corregida -->
    <link rel="stylesheet" href="../css/style.css">

    <style>
        .img-preview { max-height: 150px; margin-top: 10px; display: none; }
        #noResultsRow td { font-style: italic; color: var(--secondary-color); }
         body.dark-mode #noResultsRow td { color: var(--text-muted-dark); }
         /* Estilos AJAX search results (incluidos aquí por si acaso) */
        .search-results { position: absolute; background-color: var(--panel-bg-light); border: 1px solid var(--border-color-light); border-top: none; max-height: 200px; overflow-y: auto; width: calc(100% - 2px); z-index: 1050; display: none; border-radius: 0 0 0.375rem 0.375rem; box-shadow: var(--shadow-light); margin-top: -1px; }
         body.dark-mode .search-results { background-color: var(--panel-bg-dark); border-color: var(--border-color-dark); }
        .search-results .list-group-item { cursor: pointer; padding: 0.5rem 1rem; font-size: 0.9rem; background-color: transparent !important; color: var(--text-light); }
         body.dark-mode .search-results .list-group-item { color: var(--text-dark); border-bottom: 1px solid var(--border-color-dark) !important; }
         .search-results .list-group-item:last-child { border-bottom: none !important; }
        .search-results .list-group-item:hover { background-color: rgba(0, 0, 0, 0.05) !important; }
         body.dark-mode .search-results .list-group-item:hover { background-color: rgba(255, 255, 255, 0.07) !important; }
        .search-results .result-details { font-size: 0.8rem; color: var(--secondary-color); }
         body.dark-mode .search-results .result-details { color: var(--text-muted-dark); }
         .position-relative { position: relative; }
    </style>
</head>
<body class="dashboard-page">

    <div class="d-flex" id="wrapper">

        <!-- Sidebar (Incluida - Ruta verificada) -->
        <?php require_once '../includes/sidebar.php'; ?>

        <!-- Page Content -->
        <div id="page-content-wrapper">
            <nav class="navbar navbar-expand-lg navbar-light bg-light border-bottom">
                 <div class="container-fluid">
                    <button class="btn btn-primary btn-sm" id="sidebarToggle"><i class="fas fa-align-left"></i></button>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"> <span class="navbar-toggler-icon"></span> </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav ms-auto mt-2 mt-lg-0">
                            <li class="nav-item me-2"> <button class="btn btn-sm theme-toggle-btn-nav"> <i class="fas fa-moon"></i> <span class="d-none d-sm-inline">Tema</span> </button> </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown"> <i class="fas fa-user me-1"></i> <?php echo $username; ?> </a>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="#!">Mi Perfil</a> <a class="dropdown-item" href="#!">Configuración</a>
                                    <div class="dropdown-divider"></div> <a class="dropdown-item text-danger" href="../logout.php">Cerrar Sesión</a> <!-- Ruta verificada -->
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>

            <!-- Contenido Principal de Propietarios -->
            <div class="container-fluid px-4">
                <h1 class="mt-4">Gestión de Propietarios</h1>
                <p>Administra los propietarios de los vehículos registrados.</p>

                 <div class="d-flex justify-content-between align-items-center mb-3">
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalPropietario" id="btnAgregarPropietario"> <i class="fas fa-plus me-1"></i> Agregar Propietario </button>
                 </div>

                 <!-- Buscador con Botón -->
                 <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="search" id="searchInput" class="form-control" placeholder="Buscar por Nombre, Apellido o DNI..." aria-label="Buscar">
                            <button class="btn btn-outline-secondary" type="button" id="searchButton"> <i class="fas fa-search"></i> Buscar </button>
                        </div>
                    </div>
                 </div>

                 <!-- Mensajes (Incluir el de error DB) -->
                 <?php if ($error_db): ?><div class="alert alert-danger"><?php echo htmlspecialchars($error_db); ?></div><?php endif; ?>
                 <?php if (isset($_SESSION['form_success'])): ?><div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($_SESSION['form_success']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php unset($_SESSION['form_success']); ?><?php endif; ?>
                 <?php if (isset($_SESSION['form_error'])): ?><div class="alert alert-danger alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($_SESSION['form_error']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php unset($_SESSION['form_error']); ?><?php endif; ?>


                 <!-- Tabla de Propietarios -->
                 <div class="card mb-4">
                    <div class="card-header"> <i class="fas fa-table me-1"></i> Listado de Propietarios </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover table-bordered" id="tablaPropietarios">
                                <thead class="table-dark">
                                    <tr>
                                        <th>#</th> <th>Nombre</th> <th>Apellido</th> <th>DNI</th> <th>Dirección</th>
                                        <th>Provincia</th> <th>Distrito</th> <th>Teléfono</th> <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tablaPropietariosBody">
                                    <?php if (!$error_db && empty($propietarios)): // Solo mostrar si NO hubo error DB y está vacío ?>
                                        <tr id="noDataRow"> <td colspan="9" class="text-center">No hay propietarios registrados.</td> </tr>
                                    <?php elseif (!$error_db): // Mostrar datos si NO hubo error DB ?>
                                        <?php $count = 1; ?>
                                        <?php foreach ($propietarios as $prop): ?>
                                            <tr>
                                                <td><?php echo $count++; ?></td>
                                                <td><?php echo htmlspecialchars($prop['nombre']); ?></td>
                                                <td><?php echo htmlspecialchars($prop['apellido']); ?></td>
                                                <td><?php echo htmlspecialchars($prop['dni']); ?></td>
                                                <td><?php echo htmlspecialchars($prop['direccion'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($prop['provincia'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($prop['distrito'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($prop['telefono'] ?? '-'); ?></td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-warning btnEditar"
                                                            data-bs-toggle="modal" data-bs-target="#modalPropietario"
                                                            data-id="<?php echo $prop['id']; ?>"
                                                            data-nombre="<?php echo htmlspecialchars($prop['nombre']); ?>"
                                                            data-apellido="<?php echo htmlspecialchars($prop['apellido']); ?>"
                                                            data-dni="<?php echo htmlspecialchars($prop['dni']); ?>"
                                                            data-direccion="<?php echo htmlspecialchars($prop['direccion'] ?? ''); ?>"
                                                            data-provincia="<?php echo htmlspecialchars($prop['provincia'] ?? ''); ?>"
                                                            data-distrito="<?php echo htmlspecialchars($prop['distrito'] ?? ''); ?>"
                                                            data-telefono="<?php echo htmlspecialchars($prop['telefono'] ?? ''); ?>"
                                                            title="Editar"> <i class="fas fa-edit"></i> </button>
                                                    <?php if ($user_role === 'administrador'): ?>
                                                        <button type="button" class="btn btn-sm btn-danger btnEliminar"
                                                                data-id="<?php echo $prop['id']; ?>"
                                                                data-nombre="<?php echo htmlspecialchars($prop['nombre'] . ' ' . $prop['apellido']); ?>"
                                                                title="Eliminar"> <i class="fas fa-trash-alt"></i> </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; // Fin del else para mostrar datos ?>
                                    <tr id="noResultsRow" style="display: none;"> <td colspan="9" class="text-center text-muted">No se encontraron resultados para su búsqueda.</td> </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div> <!-- /container-fluid -->
        </div> <!-- /#page-content-wrapper -->
    </div> <!-- /#wrapper -->

    <!-- Modal para Agregar/Editar Propietario -->
    <div class="modal fade" id="modalPropietario" tabindex="-1" aria-labelledby="modalPropietarioLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalPropietarioLabel">Agregar Propietario</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                     <!-- Ruta del action verificada -->
                    <form id="formPropietario" method="POST" action="../controllers/propietario_controller.php" enctype="multipart/form-data">
                        <input type="hidden" name="propietario_id" id="propietario_id" value="0">
                        <input type="hidden" name="accion" id="accion" value="agregar">
                        <div class="row">
                            <div class="col-md-6 mb-3"> <label for="nombre" class="form-label">Nombre <span class="text-danger">*</span></label> <input type="text" class="form-control" id="nombre" name="nombre" required> </div>
                            <div class="col-md-6 mb-3"> <label for="apellido" class="form-label">Apellido <span class="text-danger">*</span></label> <input type="text" class="form-control" id="apellido" name="apellido" required> </div>
                        </div>
                        <div class="row">
                             <div class="col-md-6 mb-3"> <label for="dni" class="form-label">DNI <span class="text-danger">*</span></label> <input type="text" class="form-control" id="dni" name="dni" required pattern="[0-9]{8}" title="DNI debe contener 8 dígitos"> <div class="invalid-feedback">Por favor ingresa un DNI válido de 8 dígitos.</div> </div>
                             <div class="col-md-6 mb-3"> <label for="telefonoPropietario" class="form-label">Nº Teléfono</label> <input type="tel" class="form-control" id="telefonoPropietario" name="telefono" placeholder="Ej: +51 987654321"> </div>
                        </div>
                         <div class="row">
                            <div class="col-md-6 mb-3"> <label for="direccion" class="form-label">Dirección</label> <input type="text" class="form-control" id="direccion" name="direccion"> </div>
                             <div class="col-md-6 mb-3"> <label for="provincia" class="form-label">Provincia</label> <input type="text" class="form-control" id="provincia" name="provincia"> </div>
                         </div>
                         <div class="row">
                            <div class="col-md-6 mb-3"> <label for="distrito" class="form-label">Distrito</label> <input type="text" class="form-control" id="distrito" name="distrito"> </div>
                             <div class="col-md-6 mb-3"> <label for="dni_imagen" class="form-label">Adjuntar Imagen DNI</label> <input class="form-control" type="file" id="dni_imagen" name="dni_imagen" accept="image/jpeg, image/png, image/gif"> <div class="form-text">Sube una imagen clara del DNI (JPG, PNG, GIF). Tamaño máx: 2MB.</div> <img id="imgPreview" src="#" alt="Vista previa DNI" class="img-preview img-thumbnail"/> </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary" form="formPropietario">Guardar Cambios</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Ruta JS verificada -->
    <script src="../js/script.js"></script>

    <!-- Script específico para esta página (Modal, Búsqueda, etc.) -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // --- Selectores ---
            const modalPropietarioElement = document.getElementById('modalPropietario');
            // Verificar si el elemento modal existe antes de crear la instancia
            const modalPropietario = modalPropietarioElement ? new bootstrap.Modal(modalPropietarioElement) : null;
            const formPropietario = document.getElementById('formPropietario');
            const modalTitle = document.getElementById('modalPropietarioLabel');
            const propietarioIdInput = document.getElementById('propietario_id');
            const accionInput = document.getElementById('accion');
            const imgPreview = document.getElementById('imgPreview');
            const dniImagenInput = document.getElementById('dni_imagen');
            const tablaBody = document.getElementById('tablaPropietariosBody');
            const searchInput = document.getElementById('searchInput');
            const searchButton = document.getElementById('searchButton');
            const noResultsRow = document.getElementById('noResultsRow');
            const noDataRow = document.getElementById('noDataRow');
            const telefonoInput = document.getElementById('telefonoPropietario');

            // --- Lógica del Modal (Reset, Edit<?php
// includes/sidebar.php
// Requiere que $user_role esté definida ANTES de incluir este archivo.
if (!isset($user_role)) {
    $user_role = 'usuario'; // Fallback
}

// Determinar la ruta base para los enlaces y la carpeta de vistas
// Obtener el directorio del script que INCLUYE este archivo
$including_script_directory = dirname($_SERVER['SCRIPT_FILENAME']);
$project_root = dirname(__DIR__); // Asume que 'includes' está un nivel bajo la raíz

// Comprobar si el script que incluye está directamente en la raíz del proyecto
$is_in_root = ($including_script_directory === $project_root);

// Definir las rutas base relativas
$base_path_to_root = $is_in_root ? './' : '../'; // Si está en raíz './', si está en subcarpeta '../'
$views_folder = 'views/'; // Siempre se llama 'views'

// Obtener el nombre del script actual para marcarlo como activo
$current_script = basename($_SERVER['PHP_SELF']);

?>
<div class="sidebar-wrapper" id="sidebar-wrapper">
    <div class="sidebar-heading text-center py-4 fs-4 fw-bold text-uppercase border-bottom">
        <!-- Usar base_path_to_root para la imagen -->
        <img src="<?php echo $base_path_to_root; ?>img/logo.png" alt="Logo" width="30" height="30" class="me-2">SysVehiculos
    </div>
    <div class="list-group list-group-flush my-3">
        <!-- Enlace a Dashboard (siempre desde raíz) -->
        <a href="<?php echo $base_path_to_root; ?>dashboard.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'dashboard.php') ? 'active' : ''; ?>">
            <i class="fas fa-tachometer-alt me-2"></i>Panel de Control
        </a>

        <div class="sidebar-section-title px-3 mt-3 mb-2 text-muted text-uppercase small">Registro de Vehículos</div>
        <!-- Enlaces a Vistas: Si estamos en raíz, añade 'views/', si no, no añadas nada antes del nombre -->
        <a href="<?php echo $base_path_to_root . ($is_in_root ? $views_folder : ''); ?>propietarios.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'propietarios.php') ? 'active' : ''; ?>">
            <i class="fas fa-user-tie me-2"></i>Propietarios
        </a>
        <a href="<?php echo $base_path_to_root . ($is_in_root ? $views_folder : ''); ?>conductor.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'conductor.php') ? 'active' : ''; ?>">
            <i class="fas fa-id-card me-2"></i>Conductores
        </a>
        <a href="<?php echo $base_path_to_root . ($is_in_root ? $views_folder : ''); ?>vehiculo.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'vehiculo.php') ? 'active' : ''; ?>">
            <i class="fas fa-car me-2"></i>Vehículos
        </a>

        <?php // --- Sección Administración (Solo para Admins) ---
        if ($user_role === 'administrador'): ?>
            <div class="sidebar-section-title px-3 mt-4 mb-2 text-muted text-uppercase small">Administración</div>
             <!-- Enlace a Vista Usuarios -->
            <a href="<?php echo $base_path_to_root . ($is_in_root ? $views_folder : ''); ?>usuarios.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'usuarios.php') ? 'active' : ''; ?>">
                <i class="fas fa-users-cog me-2"></i>Usuarios
            </a>
        <?php endif; // --- Fin Sección Admin ---
        ?>

        <!-- Enlace a Logout (siempre desde raíz) -->
        <a href="<?php echo $base_path_to_root; ?>logout.php" class="list-group-item list-group-item-action text-danger mt-auto">
            <i class="fas fa-sign-out-alt me-2"></i>Cerrar Sesión
        </a>
    </div>
</div><?php
// includes/sidebar.php
// Requiere que $user_role esté definida ANTES de incluir este archivo.
if (!isset($user_role)) {
    $user_role = 'usuario'; // Fallback
}

// Determinar la ruta base para los enlaces y la carpeta de vistas
// Obtener el directorio del script que INCLUYE este archivo
$including_script_directory = dirname($_SERVER['SCRIPT_FILENAME']);
$project_root = dirname(__DIR__); // Asume que 'includes' está un nivel bajo la raíz

// Comprobar si el script que incluye está directamente en la raíz del proyecto
$is_in_root = ($including_script_directory === $project_root);

// Definir las rutas base relativas
$base_path_to_root = $is_in_root ? './' : '../'; // Si está en raíz './', si está en subcarpeta '../'
$views_folder = 'views/'; // Siempre se llama 'views'

// Obtener el nombre del script actual para marcarlo como activo
$current_script = basename($_SERVER['PHP_SELF']);

?>
<div class="sidebar-wrapper" id="sidebar-wrapper">
    <div class="sidebar-heading text-center py-4 fs-4 fw-bold text-uppercase border-bottom">
        <!-- Usar base_path_to_root para la imagen -->
        <img src="<?php echo $base_path_to_root; ?>img/logo.png" alt="Logo" width="30" height="30" class="me-2">SysVehiculos
    </div>
    <div class="list-group list-group-flush my-3">
        <!-- Enlace a Dashboard (siempre desde raíz) -->
        <a href="<?php echo $base_path_to_root; ?>dashboard.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'dashboard.php') ? 'active' : ''; ?>">
            <i class="fas fa-tachometer-alt me-2"></i>Panel de Control
        </a>

        <div class="sidebar-section-title px-3 mt-3 mb-2 text-muted text-uppercase small">Registro de Vehículos</div>
        <!-- Enlaces a Vistas: Si estamos en raíz, añade 'views/', si no, no añadas nada antes del nombre -->
        <a href="<?php echo $base_path_to_root . ($is_in_root ? $views_folder : ''); ?>propietarios.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'propietarios.php') ? 'active' : ''; ?>">
            <i class="fas fa-user-tie me-2"></i>Propietarios
        </a>
        <a href="<?php echo $base_path_to_root . ($is_in_root ? $views_folder : ''); ?>conductor.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'conductor.php') ? 'active' : ''; ?>">
            <i class="fas fa-id-card me-2"></i>Conductores
        </a>
        <a href="<?php echo $base_path_to_root . ($is_in_root ? $views_folder : ''); ?>vehiculo.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'vehiculo.php') ? 'active' : ''; ?>">
            <i class="fas fa-car me-2"></i>Vehículos
        </a>

        <?php // --- Sección Administración (Solo para Admins) ---
        if ($user_role === 'administrador'): ?>
            <div class="sidebar-section-title px-3 mt-4 mb-2 text-muted text-uppercase small">Administración</div>
             <!-- Enlace a Vista Usuarios -->
            <a href="<?php echo $base_path_to_root . ($is_in_root ? $views_folder : ''); ?>usuarios.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'usuarios.php') ? 'active' : ''; ?>">
                <i class="fas fa-users-cog me-2"></i>Usuarios
            </a>
        <?php endif; // --- Fin Sección Admin ---
        ?>

        <!-- Enlace a Logout (siempre desde raíz) -->
        <a href="<?php echo $base_path_to_root; ?>logout.php" class="list-group-item list-group-item-action text-danger mt-auto">
            <i class="fas fa-sign-out-alt me-2"></i>Cerrar Sesión
        </a>
    </div>
</div>ar, Preview, Eliminar) ---
            // Añadir comprobación de nulidad para modalPropietario
            document.getElementById('btnAgregarPropietario')?.addEventListener('click', function() {
                if (!modalPropietario || !formPropietario) return; // Salir si no existen
                modalTitle.textContent = 'Agregar Propietario';
                formPropietario.reset();
                propietarioIdInput.value = '0';
                accionInput.value = 'agregar';
                imgPreview.style.display = 'none'; imgPreview.src = '#';
                formPropietario.classList.remove('was-validated');
             });

            tablaBody?.addEventListener('click', function(event) { // Añadir ?
                const targetEdit = event.target.closest('.btnEditar');
                const targetDelete = event.target.closest('.btnEliminar');

                if (targetEdit && modalPropietario && formPropietario) { // Comprobar modal y form
                    modalTitle.textContent = 'Editar Propietario';
                    propietarioIdInput.value = targetEdit.dataset.id;
                    accionInput.value = 'editar';
                    document.getElementById('nombre').value = targetEdit.dataset.nombre;
                    document.getElementById('apellido').value = targetEdit.dataset.apellido;
                    document.getElementById('dni').value = targetEdit.dataset.dni;
                    document.getElementById('direccion').value = targetEdit.dataset.direccion;
                    document.getElementById('provincia').value = targetEdit.dataset.provincia;
                    document.getElementById('distrito').value = targetEdit.dataset.distrito;
                    telefonoInput.value = targetEdit.dataset.telefono;
                    imgPreview.style.display = 'none'; imgPreview.src = '#';
                    if(dniImagenInput) dniImagenInput.value = ''; // Comprobar input
                    formPropietario.classList.remove('was-validated');
                    // No se abre el modal aquí, se hace con data-bs-toggle en el botón
                } else if (targetDelete) {
                    const propietarioId = targetDelete.dataset.id;
                    const propietarioNombre = targetDelete.dataset.nombre;
                    if (confirm(`¿Estás seguro de que deseas eliminar al propietario "${propietarioNombre}" (ID: ${propietarioId})? Esta acción no se puede deshacer.`)) {
                        const formDelete = document.createElement('form');
                        formDelete.method = 'POST';
                        formDelete.action = '../controllers/propietario_controller.php'; // Ruta verificada
                        const idInput = document.createElement('input'); idInput.type = 'hidden'; idInput.name = 'propietario_id'; idInput.value = propietarioId; formDelete.appendChild(idInput);
                        const actionInput = document.createElement('input'); actionInput.type = 'hidden'; actionInput.name = 'accion'; actionInput.value = 'eliminar'; formDelete.appendChild(actionInput);
                        document.body.appendChild(formDelete); formDelete.submit();
                    }
                }
            });

             dniImagenInput?.addEventListener('change', function(event) { // Añadir ?
                 if(!imgPreview) return; // Comprobar preview
                 const file = event.target.files[0];
                 if (file && file.type.startsWith('image/')) { const reader = new FileReader(); reader.onload = function(e) { imgPreview.src = e.target.result; imgPreview.style.display = 'block'; }; reader.readAsDataURL(file); } else { imgPreview.src = '#'; imgPreview.style.display = 'none'; }
             });

            // --- Lógica de Búsqueda ---
            function performSearch() {
                if (!searchInput || !tablaBody || !noResultsRow) return; // Comprobar elementos
                const searchTerm = searchInput.value.toLowerCase().trim();
                const rows = tablaBody.querySelectorAll('tr:not(#noResultsRow):not(#noDataRow)');
                let resultsFound = false;

                rows.forEach(row => {
                    const nombre = row.cells[1]?.textContent.toLowerCase() || '';
                    const apellido = row.cells[2]?.textContent.toLowerCase() || '';
                    const dni = row.cells[3]?.textContent.toLowerCase() || '';
                    if (nombre.includes(searchTerm) || apellido.includes(searchTerm) || dni.includes(searchTerm)) {
                        row.style.display = ''; resultsFound = true;
                    } else {
                        row.style.display = 'none';
                    }
                });

                noResultsRow.style.display = resultsFound ? 'none' : '';
                if (noDataRow) {
                     noDataRow.style.display = (searchTerm === '' && <?php echo empty($propietarios) ? 'true' : 'false'; ?>) ? '' : 'none';
                 }
                 if (searchTerm === '') {
                    rows.forEach(row => row.style.display = '');
                    noResultsRow.style.display = 'none';
                 }
            }

            searchButton?.addEventListener('click', performSearch); // Añadir ?
            searchInput?.addEventListener('keypress', function(event) { // Añadir ?
                if (event.key === 'Enter') { event.preventDefault(); performSearch(); }
            });

        }); // Fin DOMContentLoaded
    </script>

</body>
</html>