<?php
// includes/sidebar.php
// Objetivo: Generar el menú lateral dinámicamente, ajustando las rutas
// y mostrando opciones según el rol del usuario.

// Requisito: La variable $user_role debe estar definida en el script
// que incluye este archivo (ej: dashboard.php, propietarios.php, etc.)
// ANTES de esta línea de require_once.
if (!isset($user_role)) {
    // Si no está definida (error en el script que incluye),
    // se asigna un rol por defecto para evitar errores fatales.
    $user_role = 'usuario';
    // Opcional: Registrar un error para facilitar la depuración
    error_log("Advertencia: \$user_role no definida antes de incluir includes/sidebar.php. Usando 'usuario' por defecto.");
}

// --- Cálculo Inteligente de Rutas Relativas ---

// 1. Directorio del script que está incluyendo este archivo
$including_script_directory = dirname($_SERVER['SCRIPT_FILENAME']);

// 2. Directorio raíz del proyecto (asume que 'includes' está un nivel bajo la raíz)
$project_root = dirname(__DIR__);

// 3. Determinar si el script que incluye está directamente en la raíz
$is_in_root = (realpath($including_script_directory) === realpath($project_root));

// 4. Definir la ruta base para volver a la raíz del proyecto
$base_path_to_root = $is_in_root ? './' : '../';

// 5. Nombre de la carpeta de vistas
$views_folder_name = 'views/';

// 6. Nombre del archivo PHP actual (para marcar el enlace activo)
$current_script = basename($_SERVER['PHP_SELF']);

// --- Fin Cálculo de Rutas ---

?>
<div class="sidebar-wrapper" id="sidebar-wrapper">
    <div class="sidebar-heading text-center py-4 fs-4 fw-bold text-uppercase border-bottom">
        <!-- La ruta a la imagen siempre usa $base_path_to_root --> 
        <img src="<?php echo htmlspecialchars($base_path_to_root); ?>img/logo.png" alt="Logo SysVehiculos" width="200" height="30" class="me-2">
    </div>
    <div class="list-group list-group-flush my-3">

        <!-- Enlace a Dashboard -->
        <a href="<?php echo htmlspecialchars($base_path_to_root); ?>dashboard.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'dashboard.php') ? 'active' : ''; ?>">
            <i class="fas fa-tachometer-alt me-2"></i>Panel de Control
        </a>

        <!-- Sección Registros -->
        <div class="sidebar-section-title px-3 mt-3 mb-2 text-muted text-uppercase small">Registro de Vehículos</div>

        <!-- Enlaces a las Vistas (Ruta calculada) -->
        <?php
            // Construir la ruta completa a la carpeta de vistas
            $link_path_views = $base_path_to_root . $views_folder_name;
        ?>
        <a href="<?php echo htmlspecialchars($link_path_views); ?>propietarios.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'propietarios.php') ? 'active' : ''; ?>">
            <i class="fas fa-user-tie me-2"></i>Propietarios
        </a>
        <a href="<?php echo htmlspecialchars($link_path_views); ?>conductor.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'conductor.php') ? 'active' : ''; ?>">
            <i class="fas fa-id-card me-2"></i>Conductores
        </a>
        <a href="<?php echo htmlspecialchars($link_path_views); ?>vehiculo.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'vehiculo.php') ? 'active' : ''; ?>">
            <i class="fas fa-car me-2"></i>Vehículos
        </a>

        <?php // --- Sección Administración (Solo visible para rol 'administrador') ---
        // ESTA ES LA CONDICIÓN IMPORTANTE
        if ($user_role === 'administrador'):
        ?>
            <div class="sidebar-section-title px-3 mt-4 mb-2 text-muted text-uppercase small">Administración</div>
            <a href="<?php echo htmlspecialchars($link_path_views); ?>usuarios.php" class="list-group-item list-group-item-action <?php echo ($current_script === 'usuarios.php') ? 'active' : ''; ?>">
                <i class="fas fa-users-cog me-2"></i>Usuarios
            </a>
        <?php
        endif; // --- Fin Sección Administración ---
        ?>

        <!-- Enlace de Logout (siempre relativo a la raíz) -->
        <a href="<?php echo htmlspecialchars($base_path_to_root); ?>logout.php" class="list-group-item list-group-item-action text-danger mt-auto">
            <i class="fas fa-sign-out-alt me-2"></i>Cerrar Sesión
        </a>
    </div>
</div>