<?php
// dashboard.php - Panel Principal con Búsqueda PHP Integrada (SIN AJAX)

// 1. Iniciar sesión ANTES de cualquier salida
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// 2. Verificar si el usuario está logueado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php?error=not_logged_in');
    exit;
}

// 3. Recuperar información del usuario de la sesión
$username = isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Usuario';
$userId = $_SESSION['user_id'];

// 4. --- Definir Rol de Usuario ---
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'usuario';
// ---------------------------------

// 5. Incluir conexión a la BD
require_once 'config/db.php';

// 6. --- OBTENER ESTADÍSTICAS ---
$stats = [ 'propietarios' => 0, 'conductores' => 0, 'vehiculos' => 0, 'usuarios' => 0 ];
$stats_error = null;
try {
    if (!isset($pdo)) { throw new Exception("Error: Conexión a BD no definida."); }
    $stmt = $pdo->query("SELECT COUNT(*) FROM propietarios"); $stats['propietarios'] = $stmt->fetchColumn();
    $stmt = $pdo->query("SELECT COUNT(*) FROM conductores"); $stats['conductores'] = $stmt->fetchColumn();
    $stmt = $pdo->query("SELECT COUNT(*) FROM vehiculos"); $stats['vehiculos'] = $stmt->fetchColumn();
    if ($user_role === 'administrador') { $stmt = $pdo->query("SELECT COUNT(*) FROM usuarios"); $stats['usuarios'] = $stmt->fetchColumn(); }
} catch (Exception $e) {
    error_log("Error PDO al obtener estadísticas dashboard: " . $e->getMessage());
    $stats_error = "No se pudieron cargar las estadísticas.";
}

// 7. --- LÓGICA DE BÚSQUEDA PHP ---
$resultados_busqueda = [];
$error_busqueda_dash = null;
$termino_buscado_dash = isset($_GET['term_dash']) ? trim($_GET['term_dash']) : ''; // Usar 'term_dash' para evitar conflicto

if (!empty($termino_buscado_dash)) {
    if (!isset($pdo)) {
        $error_busqueda_dash = "Error interno: No se pudo conectar a la BD para buscar.";
    } else {
        try {
            $sql = "SELECT
                        v.id as vehiculo_id, v.placa, v.color, v.marca, v.modelo, v.anio_modelo, v.tablero, v.anotacion1, v.anotacion2,
                        p.id as propietario_id, p.nombre as p_nombre, p.apellido as p_apellido, p.dni as p_dni, p.direccion as p_direccion, p.provincia as p_provincia, p.distrito as p_distrito, p.telefono as p_telefono,
                        c.id as conductor_id, c.nombre as c_nombre, c.apellido as c_apellido, c.dni as c_dni, c.licencia_conducir as c_licencia, c.telefono as c_telefono
                    FROM vehiculos v
                    JOIN propietarios p ON v.propietario_id = p.id
                    LEFT JOIN conductores c ON v.conductor_id = c.id
                    WHERE v.placa = :term_placa
                       OR v.tablero LIKE :term_tablero
                       OR p.dni = :term_dni";

            $stmt = $pdo->prepare($sql);
            $termPlaca = $termino_buscado_dash;
            $termTablero = "%" . $termino_buscado_dash . "%";
            $termDni = $termino_buscado_dash;
            $stmt->bindParam(':term_placa', $termPlaca, PDO::PARAM_STR);
            $stmt->bindParam(':term_tablero', $termTablero, PDO::PARAM_STR);
            $stmt->bindParam(':term_dni', $termDni, PDO::PARAM_STR);
            $stmt->execute();
            $resultados_busqueda = $stmt->fetchAll(PDO::FETCH_ASSOC); // Guardar resultados aquí

        } catch (PDOException $e) {
            error_log("Error en búsqueda dashboard.php: " . $e->getMessage());
            $error_busqueda_dash = "Error al consultar la base de datos.";
        }
    }
}
// Función para escapar HTML
function escapeHtmlDash($unsafe) {
    if ($unsafe === null || $unsafe === '') return '-';
    return htmlspecialchars(strval($unsafe), ENT_QUOTES, 'UTF-8');
}
// --- FIN LÓGICA BÚSQUEDA PHP ---

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - SysVehiculos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="css/style.css">
    
    <!-- === FAVICON === -->
    <!-- Ruta relativa desde la raíz a la carpeta img/ -->
    <link rel="icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <!-- Opcional: Si tienes un apple-touch-icon.png en /img/ -->
    <!-- <link rel="apple-touch-icon" href="img/apple-touch-icon.png"> -->
    <!-- ============= -->
     
    <style>
        /* ... (Estilos de .stat-card) ... */
        .stat-card { border-left: 5px solid var(--primary-color); transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out; }
        .stat-card:hover { transform: translateY(-3px); box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        .stat-card .card-body { display: flex; align-items: center; justify-content: space-between; }
        .stat-card .stat-icon { font-size: 2.5rem; opacity: 0.6; color: var(--secondary-color); }
         body.dark-mode .stat-card .stat-icon { color: var(--text-muted-dark); }
        .stat-card .stat-value { font-size: 1.8rem; font-weight: bold; }
        .stat-card .stat-label { font-size: 0.9rem; text-transform: uppercase; color: var(--secondary-color); }
         body.dark-mode .stat-card .stat-label { color: var(--text-muted-dark); }
        .stat-card.border-primary { border-left-color: var(--bs-primary); }
        .stat-card.border-success { border-left-color: var(--bs-success); }
        .stat-card.border-info    { border-left-color: var(--bs-info); }
        .stat-card.border-warning { border-left-color: var(--bs-warning); }
         /* Estilos para resultados de búsqueda */
         #dashboardSearchResults .result-item { margin-bottom: 1.5rem; padding-bottom: 1.5rem; border-bottom: 1px dashed var(--result-border-light); }
         #dashboardSearchResults .result-item:last-child { margin-bottom: 0; padding-bottom: 0; border-bottom: none; }
         #dashboardSearchResults .result-item h5 { color: var(--primary-color); margin-bottom: 0.75rem; font-weight: 600; border-bottom: 2px solid var(--primary-color); padding-bottom: 0.3rem; display: inline-block; font-size: 1rem; }
         #dashboardSearchResults .data-list dt { font-weight: 600; color: var(--secondary-color); font-size: 0.8rem; margin-bottom: 0.1rem; padding-right: 0.5em; text-transform: uppercase; }
         #dashboardSearchResults .data-list dd { margin-left: 0; margin-bottom: 0.4rem; font-size: 0.9rem; word-wrap: break-word; }
         #dashboardSearchResults .data-list dd:last-child { margin-bottom: 0; }
         body.dark-mode #dashboardSearchResults .result-item { border-bottom-color: var(--result-border-dark); }
         body.dark-mode #dashboardSearchResults .result-item h5 { color: var(--link-color-dark); border-bottom-color: var(--link-color-dark); }
         body.dark-mode #dashboardSearchResults .data-list dt { color: var(--footer-text-dark); }
         body.dark-mode #dashboardSearchResults .data-list dd { color: var(--text-dark); }
         body.dark-mode #dashboardSearchResults .text-muted { color: var(--footer-text-dark) !important; }
         #dashboardResultsContent .alert { margin-top: 1rem; }
         /* Ocultar área de resultados inicialmente si no hay búsqueda */
         .results-area:not(.results-found) { display: none; }
    </style>
</head>
<body class="dashboard-page">
    <div class="d-flex" id="wrapper">
        <?php require_once 'includes/sidebar.php'; ?>
        <div id="page-content-wrapper">
            <nav class="navbar navbar-expand-lg navbar-light bg-light border-bottom">
                 <!-- Navbar -->
                 <div class="container-fluid"> <button class="btn btn-primary btn-sm" id="sidebarToggle"><i class="fas fa-align-left"></i></button> <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"> <span class="navbar-toggler-icon"></span> </button> <div class="collapse navbar-collapse" id="navbarSupportedContent"> <ul class="navbar-nav ms-auto mt-2 mt-lg-0"> <li class="nav-item me-2"> <button class="btn btn-sm theme-toggle-btn-nav"> <i class="fas fa-moon"></i> <span class="d-none d-sm-inline">Tema</span> </button> </li> <li class="nav-item dropdown"> <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown"> <i class="fas fa-user me-1"></i> <?php echo $username; ?> </a> <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown"> <a class="dropdown-item" href="#!">Mi Perfil</a> <a class="dropdown-item" href="#!">Configuración</a> <div class="dropdown-divider"></div> <a class="dropdown-item text-danger" href="logout.php">Cerrar Sesión</a> </div> </li> </ul> </div> </div>
            </nav>
            <div class="container-fluid px-4">
                <h1 class="mt-4">Panel de Control</h1>
                 <!-- Mensajes -->
                 <?php if (isset($_SESSION['access_error'])): ?> <div class="alert alert-warning alert-dismissible fade show mt-3" role="alert"> <?php echo escapeHtmlDash($_SESSION['access_error']); ?> <button type="button" class="btn-close" data-bs-dismiss="alert"></button> </div> <?php unset($_SESSION['access_error']); ?> <?php endif; ?>
                 <?php if ($stats_error): ?> <div class="alert alert-danger mt-3" role="alert"><?php echo escapeHtmlDash($stats_error); ?></div> <?php endif; ?>
                <p class="mt-3">Bienvenido al panel de administración, <strong><?php echo $username; ?></strong>.</p>
                <!-- Tarjetas Estadísticas -->
                <div class="row mt-4"> <div class="col-xl-3 col-md-6 mb-4"> <div class="card shadow h-100 py-2 stat-card border-primary"> <div class="card-body"> <div class="stat-content"> <div class="stat-label text-primary">Vehículos</div> <div class="stat-value"><?php echo $stats['vehiculos']; ?></div> </div> <div class="stat-icon"><i class="fas fa-car"></i></div> </div> </div> </div> <div class="col-xl-3 col-md-6 mb-4"> <div class="card shadow h-100 py-2 stat-card border-success"> <div class="card-body"> <div class="stat-content"> <div class="stat-label text-success">Propietarios</div> <div class="stat-value"><?php echo $stats['propietarios']; ?></div> </div> <div class="stat-icon"><i class="fas fa-user-tie"></i></div> </div> </div> </div> <div class="col-xl-3 col-md-6 mb-4"> <div class="card shadow h-100 py-2 stat-card border-info"> <div class="card-body"> <div class="stat-content"> <div class="stat-label text-info">Conductores</div> <div class="stat-value"><?php echo $stats['conductores']; ?></div> </div> <div class="stat-icon"><i class="fas fa-id-card"></i></div> </div> </div> </div> <?php if ($user_role === 'administrador'): ?> <div class="col-xl-3 col-md-6 mb-4"> <div class="card shadow h-100 py-2 stat-card border-warning"> <div class="card-body"> <div class="stat-content"> <div class="stat-label text-warning">Usuarios</div> <div class="stat-value"><?php echo $stats['usuarios']; ?></div> </div> <div class="stat-icon"><i class="fas fa-users-cog"></i></div> </div> </div> </div> <?php endif; ?> </div>
                <hr class="my-4">
                <!-- SECCIÓN DE BÚSQUEDA PHP -->
                <h2 class="h4 mb-3">Buscar Detalles</h2>
                <!-- Formulario apunta a sí mismo con GET -->
                <form id="dashboardSearchForm" class="mb-4" action="dashboard.php" method="GET">
                    <div class="input-group shadow-sm">
                        <!-- Input con name="term_dash" y value actual -->
                        <input type="search" id="dashboardSearchInput" name="term_dash" class="form-control" placeholder="Buscar por DNI (Propietario), Placa o Tablero..." value="<?php echo htmlspecialchars($termino_buscado_dash); ?>" aria-label="Término de búsqueda">
                        <button class="btn btn-outline-secondary" type="submit" id="dashboardSearchButton">
                            <i class="fas fa-search me-1"></i> Buscar
                        </button>
                    </div>
                </form>

                <!-- Área de Resultados PHP -->
                <!-- Añadir clase 'results-found' si hay resultados para mostrar el div -->
                <div id="dashboardSearchResults" class="results-area mt-4 <?php echo !empty($termino_buscado_dash) ? 'results-found' : ''; ?>">
                    <div id="dashboardResultsContent">
                        <?php if (!empty($termino_buscado_dash)): // Solo mostrar si se buscó algo ?>
                            <?php if ($error_busqueda_dash): ?>
                                <div class="alert alert-danger error-message"><?php echo escapeHtmlDash($error_busqueda_dash); ?></div>
                            <?php elseif (empty($resultados_busqueda)): ?>
                                <div class="alert alert-warning no-results-message">No se encontraron resultados para "<?php echo escapeHtmlDash($termino_buscado_dash); ?>".</div>
                            <?php else: ?>
                                <?php foreach ($resultados_busqueda as $index => $row): ?>
                                    <div class="card result-item mb-3 shadow-sm <?php echo $index > 0 ? 'mt-3 pt-3 border-top' : ''; ?>">
                                        <div class="card-body">
                                            <!-- Sección Vehículo -->
                                            <?php if ($row['vehiculo_id']): ?>
                                                <h5><i class="fas fa-car me-2"></i> Vehículo: <strong><?php echo escapeHtmlDash($row['placa']); ?></strong></h5>
                                                <dl class="row data-list">
                                                    <dt class="col-sm-4 col-md-3">Marca:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['marca']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Modelo:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['modelo']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Año:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['anio_modelo']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Color:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['color']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Tablero:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['tablero']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Anotación 1:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['anotacion1']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Anotación 2:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['anotacion2']); ?></dd>
                                                </dl>
                                                <hr class="my-3">
                                            <?php endif; ?>

                                            <!-- Sección Propietario -->
                                            <?php if ($row['propietario_id']): ?>
                                                <h5 class="mt-3"><i class="fas fa-user-tie me-2"></i> Propietario</h5>
                                                <dl class="row data-list">
                                                    <dt class="col-sm-4 col-md-3">Nombre:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['p_nombre']) . ' ' . escapeHtmlDash($row['p_apellido']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">DNI:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['p_dni']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Dirección:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['p_direccion']) . ', ' . escapeHtmlDash($row['p_distrito']) . ', ' . escapeHtmlDash($row['p_provincia']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Teléfono:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['p_telefono']); ?></dd>
                                                </dl>
                                            <?php else: ?>
                                                <p class="text-muted mt-3"><em>Propietario no encontrado.</em></p>
                                            <?php endif; ?>

                                            <!-- Sección Conductor -->
                                            <?php if ($row['conductor_id']): ?>
                                                <hr class="my-3">
                                                <h5 class="mt-3"><i class="fas fa-id-card me-2"></i> Conductor Asignado</h5>
                                                <dl class="row data-list">
                                                    <dt class="col-sm-4 col-md-3">Nombre:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['c_nombre']) . ' ' . escapeHtmlDash($row['c_apellido']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">DNI:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['c_dni']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Licencia:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['c_licencia']); ?></dd>
                                                    <dt class="col-sm-4 col-md-3">Teléfono:</dt><dd class="col-sm-8 col-md-9"><?php echo escapeHtmlDash($row['c_telefono']); ?></dd>
                                                </dl>
                                            <?php else: ?>
                                                 <hr class="my-3">
                                                 <p class="text-muted mb-0"><em>Vehículo sin conductor asignado.</em></p>
                                            <?php endif; ?>
                                        </div><!-- /card-body -->
                                    </div><!-- /card -->
                                <?php endforeach; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div> <!-- /#dashboardResultsContent -->
                </div> <!-- /#dashboardSearchResults -->
                <!-- FIN SECCIÓN DE BÚSQUEDA PHP -->

            </div> <!-- /container-fluid -->
        </div> <!-- /#page-content-wrapper -->
    </div> <!-- /#wrapper -->

    <!-- Scripts JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery YA NO ES NECESARIO para esta página si script.js no lo usa -->
    <!-- <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script> -->
    <!-- Script JS Global (Asegúrate que no dependa de jQuery si lo quitaste) -->
    <script src="js/script.js"></script>
    <!-- EL BLOQUE SCRIPT AJAX HA SIDO ELIMINADO -->

</body>
</html>