<?php
// controllers/propietario_controller.php

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verificar login y permisos
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: ../index.php?error=unauthorized');
    exit;
}

require_once '../config/db.php';

$accion = isset($_POST['accion']) ? $_POST['accion'] : '';
$propietario_id = isset($_POST['propietario_id']) ? (int)$_POST['propietario_id'] : 0;
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'usuario';

try {
    if ($_SERVER["REQUEST_METHOD"] == "POST") {

        // --- ACCIÓN AGREGAR ---
        if ($accion === 'agregar') {
            $nombre = trim($_POST['nombre']);
            $apellido = trim($_POST['apellido']);
            $dni = trim($_POST['dni']);
            $direccion = trim($_POST['direccion'] ?? null);
            $provincia = trim($_POST['provincia'] ?? null);
            $distrito = trim($_POST['distrito'] ?? null);
            $telefono = trim($_POST['telefono'] ?? null); // NUEVO: Obtener teléfono
            $dni_image_path = null;

            // VALIDACIONES (¡MEJORAR!)
            if (empty($nombre) || empty($apellido) || empty($dni)) { throw new Exception("Nombre, Apellido y DNI son obligatorios."); }
            if (!preg_match('/^[0-9]{8}$/', $dni)) { throw new Exception("El DNI debe tener 8 dígitos numéricos."); }
            // Añadir validación opcional para teléfono si se desea

             // --- Manejo Imagen ---
             if (isset($_FILES['dni_imagen']) && $_FILES['dni_imagen']['error'] == 0) { /* ... (código manejo imagen sin cambios) ... */
                $target_dir = "../uploads/dni/"; if (!file_exists($target_dir)) { mkdir($target_dir, 0777, true); }
                 $imageFileType = strtolower(pathinfo($_FILES["dni_imagen"]["name"], PATHINFO_EXTENSION)); $new_filename = "dni_" . $dni . "_" . time() . "." . $imageFileType; $target_file = $target_dir . $new_filename;
                 $check = getimagesize($_FILES["dni_imagen"]["tmp_name"]); if($check === false) { throw new Exception("El archivo no es una imagen válida."); }
                 if ($_FILES["dni_imagen"]["size"] > 2000000) { throw new Exception("El archivo es demasiado grande (Máx 2MB)."); }
                 if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif" ) { throw new Exception("Solo se permiten archivos JPG, JPEG, PNG y GIF."); }
                 if (move_uploaded_file($_FILES["dni_imagen"]["tmp_name"], $target_file)) { $dni_image_path = $new_filename; } else { throw new Exception("Hubo un error al subir la imagen."); }
            }
             // --- Fin Manejo Imagen ---

            // MODIFICADO: Añadir 'telefono' y placeholder '?'
            $sql = "INSERT INTO propietarios (nombre, apellido, dni, direccion, provincia, distrito, telefono, dni_image_path) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            // MODIFICADO: Añadir $telefono al array execute
            $stmt->execute([$nombre, $apellido, $dni, $direccion, $provincia, $distrito, $telefono, $dni_image_path]);
            $_SESSION['form_success'] = "Propietario agregado exitosamente.";

        // --- ACCIÓN EDITAR ---
        } elseif ($accion === 'editar' && $propietario_id > 0) {
            $nombre = trim($_POST['nombre']);
            $apellido = trim($_POST['apellido']);
            $dni = trim($_POST['dni']);
            $direccion = trim($_POST['direccion'] ?? null);
            $provincia = trim($_POST['provincia'] ?? null);
            $distrito = trim($_POST['distrito'] ?? null);
            $telefono = trim($_POST['telefono'] ?? null); // NUEVO: Obtener teléfono
            $nuevo_dni_image_path = null;

             // --- Manejo Imagen Edición ---
             if (isset($_FILES['dni_imagen']) && $_FILES['dni_imagen']['error'] == 0) { /* ... (código manejo imagen igual) ... */
                $target_dir = "../uploads/dni/"; if (!file_exists($target_dir)) { mkdir($target_dir, 0777, true); }
                 $imageFileType = strtolower(pathinfo($_FILES["dni_imagen"]["name"], PATHINFO_EXTENSION)); $new_filename = "dni_" . $dni . "_" . time() . "." . $imageFileType; $target_file = $target_dir . $new_filename;
                 if (move_uploaded_file($_FILES["dni_imagen"]["tmp_name"], $target_file)) { $nuevo_dni_image_path = $new_filename; /* Opcional: borrar anterior */ } else { throw new Exception("Hubo un error al subir la nueva imagen."); }
            }
             // --- Fin Manejo Imagen Edición ---

            // MODIFICADO: Añadir 'telefono = ?'
            if ($nuevo_dni_image_path !== null) {
                $sql = "UPDATE propietarios SET nombre = ?, apellido = ?, dni = ?, direccion = ?, provincia = ?, distrito = ?, telefono = ?, dni_image_path = ? WHERE id = ?";
                $stmt = $pdo->prepare($sql);
                // MODIFICADO: Añadir $telefono al execute
                $stmt->execute([$nombre, $apellido, $dni, $direccion, $provincia, $distrito, $telefono, $nuevo_dni_image_path, $propietario_id]);
            } else {
                $sql = "UPDATE propietarios SET nombre = ?, apellido = ?, dni = ?, direccion = ?, provincia = ?, distrito = ?, telefono = ? WHERE id = ?";
                $stmt = $pdo->prepare($sql);
                // MODIFICADO: Añadir $telefono al execute
                $stmt->execute([$nombre, $apellido, $dni, $direccion, $provincia, $distrito, $telefono, $propietario_id]);
            }
            $_SESSION['form_success'] = "Propietario actualizado exitosamente.";

        // --- ACCIÓN ELIMINAR ---
        } elseif ($accion === 'eliminar' && $propietario_id > 0) {
             if ($user_role !== 'administrador') { throw new Exception("No tienes permiso para realizar esta acción."); }
             // (Opcional: borrar imagen del servidor)
             $sql = "DELETE FROM propietarios WHERE id = ?";
             $stmt = $pdo->prepare($sql);
             $stmt->execute([$propietario_id]);
             $_SESSION['form_success'] = "Propietario eliminado exitosamente.";

        } else {
            throw new Exception("Acción no válida o ID de propietario faltante.");
        }
    } else {
         throw new Exception("Método de solicitud no válido.");
    }

    // Redirigir de vuelta
    header('Location: ../views/propietarios.php');
    exit;

} catch (PDOException | Exception $e) {
    error_log("Error en propietario_controller: " . $e->getMessage());
    $_SESSION['form_error'] = "Error: " . $e->getMessage();
    header('Location: ../views/propietarios.php');
    exit;
}
?>