<?php
require_once '../config/db.php'; // Ajusta ruta si es necesario

header('Content-Type: application/json'); // Indicar que la respuesta es JSON

$term = isset($_GET['term']) ? trim($_GET['term']) : '';
$results = ['error' => 'Término de búsqueda vacío']; // Mensaje por defecto

if (!empty($term)) {
    try {
        // Buscar por nombre, apellido o DNI
        $sql = "SELECT id, nombre, apellido, dni, telefono
                FROM propietarios
                WHERE nombre LIKE :term1
                   OR apellido LIKE :term2
                   OR dni LIKE :term3
                ORDER BY apellido, nombre
                LIMIT 10"; // Limitar resultados

        $searchTerm = "%" . $term . "%";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':term1', $searchTerm, PDO::PARAM_STR);
        $stmt->bindParam(':term2', $searchTerm, PDO::PARAM_STR);
        $stmt->bindParam(':term3', $searchTerm, PDO::PARAM_STR);
        $stmt->execute();
        $results = $stmt->fetchAll();

    } catch (PDOException $e) {
        error_log("Error search_propietario: " . $e->getMessage());
        $results = ['error' => 'Error al buscar propietarios'];
    }
}

echo json_encode($results); // Devolver resultados como JSON
?>