<?php
require_once '../config/db.php';

header('Content-Type: application/json');

$term = isset($_GET['term']) ? trim($_GET['term']) : '';
$results = ['error' => 'Término de búsqueda vacío'];

if (!empty($term)) {
    try {
        // Cambiar a tabla 'conductores'
        $sql = "SELECT id, nombre, apellido, dni, telefono
                FROM conductores
                WHERE nombre LIKE :term1
                   OR apellido LIKE :term2
                   OR dni LIKE :term3
                ORDER BY apellido, nombre
                LIMIT 10";

        $searchTerm = "%" . $term . "%";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':term1', $searchTerm, PDO::PARAM_STR);
        $stmt->bindParam(':term2', $searchTerm, PDO::PARAM_STR);
        $stmt->bindParam(':term3', $searchTerm, PDO::PARAM_STR);
        $stmt->execute();
        $results = $stmt->fetchAll();

    } catch (PDOException $e) {
        error_log("Error search_conductor: " . $e->getMessage());
        $results = ['error' => 'Error al buscar conductores'];
    }
}

echo json_encode($results);
?>